/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.conndiagnosis;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.webmonitor.model.sql.ClusterModel;
import com.hazelcast.webmonitor.repositories.sql.ClusterRepository;
import com.hazelcast.webmonitor.service.ClusterRemovedEvent;
import com.hazelcast.webmonitor.service.ConnectedToClusterEvent;
import com.hazelcast.webmonitor.service.MCClientManager;
import com.hazelcast.webmonitor.service.conndiagnosis.ConnDiagnosisService;
import com.hazelcast.webmonitor.service.conndiagnosis.ConnectionDiagnosis;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;

public class ConnDiagnosisService {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConnDiagnosisService.class);
    private static final long DIAGNOSTICS_CONNECTION_TIMEOUT = 3000L;
    private final Cache<String, ConnectionDiagnosis> storage = Caffeine.newBuilder().expireAfterWrite(30L, TimeUnit.MINUTES).build();
    private final Map<String, Collection<Consumer<ConnectionDiagnosis>>> listeners = new ConcurrentHashMap();
    private final MCClientManager clientManager;
    private final ClusterRepository clusterRepo;
    private final ExecutorService executor = ForkJoinPool.commonPool();

    public void initiateDiagnosis(String clusterName) {
        this.initiateDiagnosis(clusterName, null);
    }

    @EventListener
    public void onClusterConnected(ConnectedToClusterEvent event) {
        this.storage.invalidate((Object)event.getCluster());
    }

    @EventListener
    public void onClusterRemoved(ClusterRemovedEvent event) {
        this.storage.invalidate((Object)event.getCluster());
    }

    public void initiateDiagnosis(String clusterName, Consumer<ConnectionDiagnosis> listener) {
        this.storage.invalidate((Object)clusterName);
        ClusterModel cluster = this.clusterRepo.getCluster(clusterName);
        ConnectionDiagnosis diagnosis = new ConnectionDiagnosis(clusterName);
        this.storage.put((Object)diagnosis.getCluster(), (Object)diagnosis);
        if (listener != null) {
            this.addDiagnosisStateChangeListener(clusterName, listener);
        }
        ClientConfig clientConfig = cluster.createClientConfig();
        clientConfig.addListenerConfig(new ListenerConfig().setImplementation((java.util.EventListener)new DiagnosingConnectionListener(this, diagnosis)));
        clientConfig.getConnectionStrategyConfig().getConnectionRetryConfig().setClusterConnectTimeoutMillis(3000L);
        this.executor.submit(() -> {
            try {
                this.clientManager.connect(clientConfig);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    public ConnectionDiagnosis getDiagnosis(String clusterName) {
        return (ConnectionDiagnosis)this.storage.getIfPresent((Object)clusterName);
    }

    public void deleteDiagnosis(String clusterName) {
        this.storage.invalidate((Object)clusterName);
    }

    private void addDiagnosisStateChangeListener(String clusterName, Consumer<ConnectionDiagnosis> listener) {
        ConnectionDiagnosis currentState = (ConnectionDiagnosis)this.storage.getIfPresent((Object)clusterName);
        this.listeners.computeIfAbsent(clusterName, __ -> new ArrayList(1)).add(listener);
        if (currentState == null) {
            throw new IllegalArgumentException("diagnosis for cluster " + clusterName + " does not exist");
        }
        listener.accept(currentState);
    }

    @ConstructorProperties(value={"clientManager", "clusterRepo"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ConnDiagnosisService(MCClientManager clientManager, ClusterRepository clusterRepo) {
        this.clientManager = clientManager;
        this.clusterRepo = clusterRepo;
    }
}

