/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service;

import com.hazelcast.wan.WanPublisherState;
import com.hazelcast.wan.impl.AddWanConfigResult;
import com.hazelcast.webmonitor.controller.dto.AddWanReplicationDTO;
import com.hazelcast.webmonitor.controller.exception.OperationFailedApiException;
import com.hazelcast.webmonitor.service.MemberIdentifier;
import com.hazelcast.webmonitor.service.OperationDispatcher;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.UUID;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class WanReplicationManager {
    private final OperationDispatcher dispatcher;

    public UUID syncMap(String cluster, String wanReplicationName, String wanPublisherId, String map) {
        return (UUID)this.dispatcher.executeOnCluster(cluster, mcs -> mcs.wanSyncMap(wanReplicationName, wanPublisherId, map), e -> String.format("Failed to initiate WAN sync for cluster %s,  WAN replication %s, WAN publisher ID %s, map %s.", cluster, wanReplicationName, wanPublisherId, map));
    }

    public UUID syncAllMaps(String cluster, String wanReplicationName, String wanPublisherId) {
        return (UUID)this.dispatcher.executeOnCluster(cluster, mcs -> mcs.wanSyncAllMaps(wanReplicationName, wanPublisherId), e -> String.format("Failed to initiate WAN sync for all maps of cluster %s, WAN replication %s, WAN publisher ID %s.", cluster, wanReplicationName, wanPublisherId));
    }

    public UUID checkConsistency(String cluster, String wanReplicationName, String wanPublisherId, String map) {
        return (UUID)this.dispatcher.executeOnCluster(cluster, mcs -> mcs.checkWanConsistency(wanReplicationName, wanPublisherId, map), e -> String.format("Failed to initiate WAN consistency check for cluster %s, WAN replication %s, WAN publisher ID %s, map %s.", cluster, wanReplicationName, wanPublisherId, map));
    }

    public void clearQueues(String cluster, String wanReplicationName, String wanPublisherId) {
        ArrayList errorMessages = new ArrayList();
        this.dispatcher.executeOnAllMembers(cluster, (mcs, member) -> mcs.clearWanQueues(member, wanReplicationName, wanPublisherId), (member, e) -> {
            errorMessages.add(String.format("Failed to clear WAN queues for cluster %s, WAN replication %s, WAN publisher ID %s, member %s.", cluster, wanReplicationName, wanPublisherId, member));
            return null;
        });
        if (!errorMessages.isEmpty()) {
            throw new OperationFailedApiException(String.join((CharSequence)"\n", errorMessages));
        }
    }

    public void clearQueues(String cluster, String wanReplicationName, String wanPublisherId, String memberAddress) {
        this.dispatcher.executeOnMember(MemberIdentifier.of((String)cluster, (String)memberAddress), (mcs, member) -> mcs.clearWanQueues(member, wanReplicationName, wanPublisherId), e -> String.format("Failed to clear WAN queues for cluster %s, WAN replication %s, WAN publisher ID %s.", cluster, wanReplicationName, wanPublisherId));
    }

    public void changeState(String cluster, String wanReplicationName, String wanPublisherId, WanPublisherState newState) {
        ArrayList errorMessages = new ArrayList();
        this.dispatcher.executeOnAllMembers(cluster, (mcs, member) -> mcs.changeWanReplicationState(member, wanReplicationName, wanPublisherId, newState), (member, e) -> {
            errorMessages.add(String.format("Request timed out. Could not change WAN state on member %s: %s%n", member, e.getMessage()));
            return null;
        });
        if (!errorMessages.isEmpty()) {
            throw new OperationFailedApiException(String.join((CharSequence)"\n", errorMessages));
        }
    }

    public void changeState(String cluster, String wanReplicationName, String wanPublisherId, String memberAddress, WanPublisherState newState) {
        this.dispatcher.executeOnMember(MemberIdentifier.of((String)cluster, (String)memberAddress), (mcs, member) -> mcs.changeWanReplicationState(member, wanReplicationName, wanPublisherId, newState), e -> String.format("Failed to change state of WAN replication %s,  WAN publisher ID %s on cluster %s.", wanReplicationName, wanPublisherId, cluster));
    }

    public AddWanConfigResult addConfig(String cluster, AddWanReplicationDTO dto) {
        return (AddWanConfigResult)this.dispatcher.executeOnCluster(cluster, mcs -> mcs.addWanReplicationConfig(dto.toModel()), e -> String.format("Failed to add WAN config %s on cluster %s.", dto, cluster));
    }

    @ConstructorProperties(value={"dispatcher"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public WanReplicationManager(OperationDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }
}

