/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class ScheduledOperationChainRegistry<T> {
    private final ConcurrentHashMap<T, Integer> idRegistry = new ConcurrentHashMap();
    private final AtomicInteger idSequence = new AtomicInteger();

    public int nextId(T member) {
        return this.idRegistry.compute(member, (m, id) -> this.idSequence.incrementAndGet());
    }

    public boolean sameAsCurrentId(T member, int id) {
        Integer currentId = (Integer)this.idRegistry.get(member);
        return currentId != null && currentId == id;
    }

    public boolean cleanUp(T member, int id) {
        return this.idRegistry.remove(member, id);
    }

    int size() {
        return this.idRegistry.size();
    }
}

