/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service;

import com.hazelcast.cluster.Member;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Set;
import lombok.Generated;
import org.springframework.context.ApplicationEvent;

public final class MembersJoinedEvent
extends ApplicationEvent {
    private final Set<Member> joinedMembers;
    private final Set<Member> reachableMembers;

    public static MembersJoinedEvent ofInitial(String cluster, Set<Member> members) {
        return new MembersJoinedEvent(cluster, members, members);
    }

    public static MembersJoinedEvent ofAdded(String cluster, Member member, Set<Member> members) {
        return new MembersJoinedEvent(cluster, Set.of(member), members);
    }

    private MembersJoinedEvent(String cluster, Set<Member> joinedMembers, Set<Member> reachableMembers) {
        super((Object)cluster);
        this.joinedMembers = joinedMembers;
        this.reachableMembers = reachableMembers;
    }

    public String getCluster() {
        return (String)this.source;
    }

    public String toString() {
        return this.getClass().getName() + "[source=%s, joinedMembers=%s, reachableMembers=%s]".formatted(this.source, this.joinedMembers, this.reachableMembers);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Set<Member> getJoinedMembers() {
        return this.joinedMembers;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Set<Member> getReachableMembers() {
        return this.reachableMembers;
    }
}

