/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service;

import com.hazelcast.webmonitor.controller.dto.MigrationStateDTO;
import com.hazelcast.webmonitor.controller.dto.clustered.ClusterHealthDTO;
import com.hazelcast.webmonitor.model.AllState;
import com.hazelcast.webmonitor.model.hz.req.state.LicenseDTO;
import com.hazelcast.webmonitor.model.sql.client.ClientFilteringConfigModel;
import com.hazelcast.webmonitor.service.ClusterManager;
import com.hazelcast.webmonitor.service.ClusterStatsService;
import com.hazelcast.webmonitor.service.StateManager;
import com.hazelcast.webmonitor.service.client_filtering.ClientFilteringService;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ClusterHealthCheckService {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClusterHealthCheckService.class);
    private final ClusterManager clusterManager;
    private final ClusterStatsService clusterStatsService;
    private final StateManager stateManager;
    private final ClientFilteringService clientFilteringService;

    public ClusterHealthDTO check(String cluster) {
        boolean enabled = this.clusterManager.getCluster(cluster).isEnabled();
        boolean connected = this.clusterManager.isClusterConnected(cluster);
        if (enabled && connected) {
            MigrationStateDTO migrationState = this.clusterStatsService.getClusterMigrationState(cluster);
            boolean safe = migrationState.getUnsafeMembers().isEmpty();
            long migrationQueueSize = migrationState.getMigrationQueueSize();
            AllState latestState = this.stateManager.getLatestState(cluster);
            ClientFilteringConfigModel clientFilteringConfig = this.clientFilteringService.getClientFilteringConfig(cluster);
            ClusterHealthDTO.ClusterHealthDTOBuilder builder = ClusterHealthDTO.builder().cluster(cluster).connected().safe(Boolean.valueOf(safe)).partitionMigrationQueueSize(Long.valueOf(migrationQueueSize)).clientFilteringMode(clientFilteringConfig.getClientFilteringMode());
            if (latestState != null) {
                int numberOfClients = (int)latestState.getClientsPerUuid().values().stream().filter(endpoint -> !"MCJVM".equals(endpoint.getClientType())).count();
                builder.members(Integer.valueOf(latestState.getMembers().size())).numberOfConnectedClients(Integer.valueOf(numberOfClients));
                latestState.getRandomMemberState().ifPresent(memberState -> {
                    LicenseDTO licenseDTO = memberState.getNodeState().getLicenseDTO();
                    builder.licenseExpirationTime(licenseDTO != null ? Long.valueOf(licenseDTO.getExpirationTime()) : null);
                });
            }
            builder.state(this.stateManager.getClusterState(cluster));
            return builder.build();
        }
        if (!enabled) {
            return ClusterHealthDTO.disabled((String)cluster);
        }
        return ClusterHealthDTO.disconnected((String)cluster);
    }

    @ConstructorProperties(value={"clusterManager", "clusterStatsService", "stateManager", "clientFilteringService"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ClusterHealthCheckService(ClusterManager clusterManager, ClusterStatsService clusterStatsService, StateManager stateManager, ClientFilteringService clientFilteringService) {
        this.clusterManager = clusterManager;
        this.clusterStatsService = clusterStatsService;
        this.stateManager = stateManager;
        this.clientFilteringService = clientFilteringService;
    }
}

