/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.security.spi.impl.builtin;

import com.hazelcast.webmonitor.controller.exception.NoUserFoundApiException;
import com.hazelcast.webmonitor.model.sql.UserCredentialsModel;
import com.hazelcast.webmonitor.repositories.sql.AuthTokenDAO;
import com.hazelcast.webmonitor.repositories.sql.ScriptDAO;
import com.hazelcast.webmonitor.repositories.sql.UserCredentialsDAO;
import com.hazelcast.webmonitor.repositories.sql.UserDAO;
import com.hazelcast.webmonitor.security.spi.SecurityConfigApiException;
import com.hazelcast.webmonitor.security.spi.SecurityProvider;
import com.hazelcast.webmonitor.security.spi.UserManagementProvider;
import com.hazelcast.webmonitor.security.spi.impl.builtin.DefaultAuthenticationProvider;
import com.hazelcast.webmonitor.security.spi.impl.builtin.PasswordStrengthChecker;
import com.hazelcast.webmonitor.service.AuthTokenManager;
import com.hazelcast.webmonitor.sql.JdbiHistories;
import com.hazelcast.webmonitor.utils.CryptoUtils;
import com.hazelcast.webmonitor.utils.StringUtil;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.springframework.security.authentication.AuthenticationProvider;

public class DefaultSecurityProvider
implements SecurityProvider,
UserManagementProvider {
    public static final String DEFAULT_SECURITY_PROVIDER_NAME = "Default";
    private static final String USERNAME_NON_ALPHANUMERIC_WARNING = "Username may only contain alpha-numeric characters, underscores and dashes.";
    private final PasswordStrengthChecker passwordStrengthChecker;
    private final Jdbi jdbi;
    private final UserDAO userDAO;
    private final UserCredentialsDAO userCredentialsDAO;
    private final ScriptDAO scriptDAO;
    private final AuthTokenDAO authTokenDAO;
    private final JdbiHistories histories;
    private final DefaultAuthenticationProvider authenticationProvider;

    public DefaultSecurityProvider(Jdbi jdbi, UserDAO userDAO, UserCredentialsDAO userCredentialsDAO, ScriptDAO scriptDAO, AuthTokenDAO authTokenDAO, JdbiHistories histories, PasswordStrengthChecker passwordStrengthChecker) {
        this(jdbi, userDAO, userCredentialsDAO, scriptDAO, authTokenDAO, histories, passwordStrengthChecker, null);
    }

    public DefaultSecurityProvider(Jdbi jdbi, UserDAO userDAO, UserCredentialsDAO userCredentialsDAO, ScriptDAO scriptDAO, AuthTokenDAO authTokenDAO, JdbiHistories histories, PasswordStrengthChecker passwordStrengthChecker, AuthTokenManager authTokenManager) {
        this.jdbi = jdbi;
        this.userDAO = userDAO;
        this.userCredentialsDAO = userCredentialsDAO;
        this.scriptDAO = scriptDAO;
        this.authTokenDAO = authTokenDAO;
        this.histories = histories;
        this.passwordStrengthChecker = passwordStrengthChecker;
        this.authenticationProvider = new DefaultAuthenticationProvider(userCredentialsDAO, authTokenManager);
    }

    public String getName() {
        return DEFAULT_SECURITY_PROVIDER_NAME;
    }

    public void saveConfig(Map<String, String> parameters) {
        String username = parameters.get("username");
        String password = parameters.get("password");
        this.createUser(username, password, SecurityProvider.ADMIN_AUTHORITY.getAuthority());
    }

    public AuthenticationProvider getAuthenticationProvider() {
        return this.authenticationProvider;
    }

    public List<UserCredentialsModel> getUsers() {
        return this.userCredentialsDAO.getUsers();
    }

    public Optional<UserCredentialsModel> getUser(String username) {
        return this.userCredentialsDAO.findByUsername(username);
    }

    public void deleteUser(String username) {
        this.jdbi.useTransaction(handle -> this.deleteUserTx(handle, username));
    }

    public void deleteUserTx(Handle handle, String username) {
        this.scriptDAO.deleteByUsernameTx(handle, username);
        this.userCredentialsDAO.deleteTx(handle, username);
        this.histories.removeByUser(username);
        this.authTokenDAO.revokeAllUserTokensTx(handle, username);
        this.userDAO.deleteTx(handle, username);
    }

    public void changePassword(String username, String password) {
        UserCredentialsModel user = (UserCredentialsModel)this.userCredentialsDAO.findByUsername(username).orElseThrow(() -> new NoUserFoundApiException(username));
        user.setPassword(CryptoUtils.generatePasswordHash((String)username, (String)password));
        this.checkPasswordComplexity(username, password);
        this.userCredentialsDAO.update(user);
    }

    public void updateUser(String username, String role) {
        UserCredentialsModel user = (UserCredentialsModel)this.userCredentialsDAO.findByUsername(username).orElseThrow(() -> new NoUserFoundApiException(username));
        user.setRole(role);
        this.userCredentialsDAO.update(user);
    }

    public void createUser(String username, String password, String role) {
        if (StringUtil.isNullOrEmptyAfterTrim((String)username) || StringUtil.isNullOrEmptyAfterTrim((String)password)) {
            throw new SecurityConfigApiException("All fields must be filled.");
        }
        if (!StringUtil.isAlphanumericWithDashAndUnderscore((String)username)) {
            throw new SecurityConfigApiException(USERNAME_NON_ALPHANUMERIC_WARNING);
        }
        Optional user = this.userCredentialsDAO.findByUsername(username);
        if (user.isPresent()) {
            throw new SecurityConfigApiException("User account with the provided username already exists.");
        }
        this.checkPasswordComplexity(username, password);
        this.jdbi.useTransaction(handle -> {
            this.userDAO.insertTx(handle, username);
            this.userCredentialsDAO.insertTx(handle, new UserCredentialsModel(username, password, role));
        });
    }

    private void checkPasswordComplexity(String username, String password) {
        EnumSet violations = this.passwordStrengthChecker.check(username, password);
        if (!violations.isEmpty()) {
            throw new SecurityConfigApiException(violations.stream().map(violation -> violation.message).collect(Collectors.joining("\n")));
        }
    }
}

