/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.security.spi.impl;

import com.hazelcast.webmonitor.configreplacer.ConfigReplacerHelper;
import com.hazelcast.webmonitor.security.spi.SecurityConfigApiException;
import com.hazelcast.webmonitor.service.Clock;
import com.hazelcast.webmonitor.service.HomeDirectoryProvider;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SecurityConfigImportService {
    private static final String IMPORT_FILE_BASE_DIR = "import";
    private static final String IMPORT_FILE = "securityHotReload.properties";
    private static final String BACKUP_FILE_PATTERN = "importedSecurityHotReload-%d.properties.bak";
    private static final Logger LOGGER = LoggerFactory.getLogger(SecurityConfigImportService.class);
    private final HomeDirectoryProvider homeDirectoryProvider;
    private final Clock clock;

    SecurityConfigImportService(HomeDirectoryProvider homeDirectoryProvider, Clock clock) {
        this.homeDirectoryProvider = homeDirectoryProvider;
        this.clock = clock;
    }

    public Properties readProperties() {
        Properties properties;
        Properties ldapProperties = new Properties();
        Path importPropertiesFile = this.importFile();
        InputStreamReader reader = new InputStreamReader(Files.newInputStream(importPropertiesFile, new OpenOption[0]), StandardCharsets.UTF_8);
        try {
            ldapProperties.load(reader);
            properties = ConfigReplacerHelper.replace((Properties)ldapProperties);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOGGER.warn(e.getMessage(), (Throwable)e);
                throw new SecurityConfigApiException("Import security configuration couldn't be read from file [" + String.valueOf(importPropertiesFile.toAbsolutePath()) + "]");
            }
        }
        reader.close();
        return properties;
    }

    public void cleanupOnSuccessfulImport() {
        try {
            LOGGER.info("renaming security properties import file from {} to {}", (Object)this.importFile(), (Object)this.importFileBackup());
            Files.move(this.importFile(), this.importFileBackup(), new CopyOption[0]);
        }
        catch (IOException e) {
            LOGGER.warn("Unable to rename import file {} to {}", (Object)this.importFile().toAbsolutePath(), (Object)this.importFileBackup().toAbsolutePath());
        }
    }

    public boolean importPropertiesAvailable() {
        return Files.exists(this.importFile(), new LinkOption[0]);
    }

    private Path importFileBackup() {
        long timestamp = this.clock.currentTimeMillis();
        return this.importFilesBaseDir().resolve(String.format(BACKUP_FILE_PATTERN, timestamp));
    }

    private Path importFilesBaseDir() {
        return this.homeDirectoryProvider.get().resolve(IMPORT_FILE_BASE_DIR);
    }

    private Path importFile() {
        return this.importFilesBaseDir().resolve(IMPORT_FILE);
    }
}

