/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.security;

import com.hazelcast.webmonitor.auditlog.AuditLogService;
import com.hazelcast.webmonitor.auditlog.impl.AuditableEvent;
import com.hazelcast.webmonitor.networking.IPAddressUtil;
import com.hazelcast.webmonitor.security.CustomAuthenticationFailureHandler;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;
import org.springframework.stereotype.Service;

@Service
@Profile(value={"!hzcloud"})
public class CustomAuthenticationFailureHandler
extends SimpleUrlAuthenticationFailureHandler {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CustomAuthenticationFailureHandler.class);
    public static final String AUTH_FAIL_URL_SUFFIX = "/login.html?auth_fail=true";
    public static final String AUTH_FAIL_TYPE_COOKIE = "AuthFailType";
    public static final String AUTH_FAIL_MSG_COOKIE = "AuthFailMsg";
    private final AuditLogService auditService;
    private final String servletContextPath;

    @Autowired
    public CustomAuthenticationFailureHandler(AuditLogService auditService, ServletContext servletContext) {
        this.auditService = auditService;
        String contextPath = servletContext.getContextPath();
        this.servletContextPath = "".equals(contextPath) ? "/" : contextPath;
    }

    public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException {
        log.debug(exception.getMessage(), (Throwable)exception);
        String username = request.getParameter("username");
        this.auditService.log(AuditableEvent.builder().typeId("MC-2003 [Auth]").message("Detected failed log in attempt").parameter("username", (Object)(username != null ? username : "N/A")).cause((Throwable)exception).ipAddress(IPAddressUtil.getIpAddress((HttpServletRequest)request)).build());
        AuthenticationFailureInfo info = new AuthenticationFailureInfo(exception);
        info.toCookies().forEach(cookie -> {
            cookie.setPath(this.servletContextPath);
            response.addCookie(cookie);
        });
        this.getRedirectStrategy().sendRedirect(request, response, AUTH_FAIL_URL_SUFFIX);
    }
}

