/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.security;

import com.hazelcast.webmonitor.auditlog.AuditLogService;
import com.hazelcast.webmonitor.auditlog.impl.AuditableEvent;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import lombok.Generated;
import org.springframework.context.annotation.Profile;
import org.springframework.security.core.session.AbstractSessionEvent;
import org.springframework.security.core.session.SessionDestroyedEvent;
import org.springframework.security.core.session.SessionInformation;
import org.springframework.security.core.session.SessionRegistryImpl;
import org.springframework.stereotype.Component;

@Component
@Profile(value={"!hzcloud"})
public class AuditLoggingSessionRegistry
extends SessionRegistryImpl {
    private final AuditLogService auditService;

    public void onApplicationEvent(AbstractSessionEvent event) {
        if (event instanceof SessionDestroyedEvent) {
            SessionDestroyedEvent sessionDestroyedEvent = (SessionDestroyedEvent)event;
            String sessionId = sessionDestroyedEvent.getId();
            SessionInformation sessionInformation = this.getSessionInformation(sessionId);
            if (sessionInformation == null) {
                return;
            }
            this.auditService.log(AuditableEvent.builder().typeId("MC-2002 [Auth]").message("User logged out or user session expired").parameter("username", sessionInformation.getPrincipal()).build());
        }
        super.onApplicationEvent(event);
    }

    @ConstructorProperties(value={"auditService"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public AuditLoggingSessionRegistry(AuditLogService auditService) {
        this.auditService = auditService;
    }
}

