/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.repositories.sql;

import com.hazelcast.webmonitor.model.sql.MemberModel;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.PreparedBatch;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import org.springframework.stereotype.Repository;

@Repository
public class MemberDAO {
    private final Jdbi jdbi;

    public List<MemberModel> findAllByCluster(String cluster) {
        return (List)this.jdbi.withHandle(handle -> {
            try (Query query = handle.createQuery("select * from members where cluster = :cluster order by address");){
                List list = ((Query)query.bind("cluster", cluster)).mapToBean(MemberModel.class).list();
                return list;
            }
        });
    }

    public List<MemberModel> findAllByClusterAndTime(String cluster, Instant time) {
        return (List)this.jdbi.withHandle(handle -> {
            try (Query query = handle.createQuery("select * from members where cluster = :cluster and       first_seen_at <= :time and ifnull(last_seen_at, :time) >= :time order by address");){
                List list = ((Query)((Query)query.bind("cluster", cluster)).bind("time", (Object)time)).mapToBean(MemberModel.class).list();
                return list;
            }
        });
    }

    public List<MemberModel> findMembersInInterval(String cluster, Instant from, Instant to) {
        return (List)this.jdbi.withHandle(handle -> {
            try (Query query = handle.createQuery("SELECT * FROM members  WHERE ((:from <= first_seen_at AND first_seen_at <= :to) OR (:from <= nvl(last_seen_at, now()) AND nvl(last_seen_at, now()) <= :to) OR (first_seen_at <= :from AND :to <= nvl(last_seen_at, now()))) AND cluster = :cluster");){
                List list = ((Query)((Query)((Query)query.bind("from", (Object)from)).bind("to", (Object)to)).bind("cluster", cluster)).mapToBean(MemberModel.class).list();
                return list;
            }
        });
    }

    public void insertOrUpdate(String cluster, Collection<String> reachableMemberAddresses, Instant eventTime) {
        this.jdbi.useTransaction(tx -> {
            try (PreparedBatch batch = tx.prepareBatch("MERGE INTO MEMBERS AS T\nUSING (VALUES (:cluster, :address, :firstSeenAt, :lastSeenAt))\n             S(CLUSTER, ADDRESS, FIRST_SEEN_AT, LAST_SEEN_AT)\nON T.CLUSTER = S.CLUSTER AND T.ADDRESS = S.ADDRESS\nWHEN MATCHED THEN\n    UPDATE SET T.LAST_SEEN_AT = S.LAST_SEEN_AT\nWHEN NOT MATCHED THEN\n    INSERT VALUES (S.CLUSTER, S.ADDRESS, S.FIRST_SEEN_AT, S.LAST_SEEN_AT);\n");){
                for (String memberAddress : reachableMemberAddresses) {
                    MemberModel model = MemberModel.builder().cluster(cluster).address(memberAddress).firstSeenAt(eventTime).build();
                    ((PreparedBatch)batch.bindBean((Object)model)).add();
                }
                batch.execute();
            }
            this.updateLastSeenAtForNotReachableTx(tx, cluster, reachableMemberAddresses, eventTime);
        });
    }

    public void updateLastSeenAtIfNotReachable(String cluster, Collection<String> reacheableMembers, Instant lastSeenAt) {
        this.jdbi.withHandle(handle -> {
            if (reacheableMembers.isEmpty()) {
                try (Update update = handle.createUpdate("update members\nset last_seen_at = :lastSeenAt\nwhere cluster = :cluster and last_seen_at is null\n");){
                    Integer n = ((Update)((Update)update.bind("cluster", cluster)).bind("lastSeenAt", (Object)lastSeenAt)).execute();
                    return n;
                }
            }
            return this.updateLastSeenAtForNotReachableTx(handle, cluster, reacheableMembers, lastSeenAt);
        });
    }

    private int updateLastSeenAtForNotReachableTx(Handle handle, String cluster, Collection<String> reacheableMembers, Instant lastSeenAt) {
        try (Update update = handle.createUpdate("update members\nset last_seen_at = :lastSeenAt\nwhere cluster = :cluster and address not in (<addresses>) and last_seen_at is null\n");){
            int n = ((Update)((Update)((Update)update.bindList("addresses", reacheableMembers)).bind("cluster", cluster)).bind("lastSeenAt", (Object)lastSeenAt)).execute();
            return n;
        }
    }

    @ConstructorProperties(value={"jdbi"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public MemberDAO(Jdbi jdbi) {
        this.jdbi = jdbi;
    }
}

