/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.repositories.sql;

import com.hazelcast.webmonitor.model.sql.HealthCheckIgnoreListEntry;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.List;
import lombok.Generated;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;

public class HealthCheckIgnoreListDAO {
    private final Jdbi jdbi;

    public void insertEntry(HealthCheckIgnoreListEntry ignoreListEntry) {
        this.jdbi.useHandle(h -> {
            try (Update update = h.createUpdate("MERGE INTO healthcheck_ignorelist  (CHECK_ID, CLUSTER, IS_DISABLED_CLUSTERWIDE, DISABLED_DATA_STRUCTURES)  VALUES (:checkId, :cluster, :isDisabledClusterWide, :disabledDataStructures)");){
                ((Update)((Update)((Update)((Update)update.bind("checkId", ignoreListEntry.getCheckId())).bind("cluster", ignoreListEntry.getCluster())).bind("isDisabledClusterWide", ignoreListEntry.getIsDisabledClusterWide())).bindArray("disabledDataStructures", String.class, (Iterable)ignoreListEntry.getDisabledDataStructures())).execute();
            }
        });
    }

    public void deleteClusterEntries(String cluster) {
        this.jdbi.useHandle(h -> {
            try (Update update = h.createUpdate("DELETE FROM healthcheck_ignorelist WHERE cluster = :cluster");){
                ((Update)update.bind("cluster", cluster)).execute();
            }
        });
    }

    public List<HealthCheckIgnoreListEntry> queryIgnoreList(String cluster) {
        return (List)this.jdbi.withHandle(h -> {
            try (Query query = h.createQuery("SELECT * FROM healthcheck_ignorelist  WHERE cluster = :cluster");){
                List list = ((Query)query.bind("cluster", cluster)).mapToBean(HealthCheckIgnoreListEntry.class).list();
                return list;
            }
        });
    }

    @ConstructorProperties(value={"jdbi"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public HealthCheckIgnoreListDAO(Jdbi jdbi) {
        this.jdbi = jdbi;
    }
}

