/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.repositories.sql;

import com.hazelcast.webmonitor.model.sql.ClusterModel;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import org.springframework.stereotype.Repository;

@Repository
public class ClusterDAO {
    private final Jdbi jdbi;

    public void insert(ClusterModel cluster) {
        this.jdbi.useHandle(handle -> this.insertTx(handle, cluster));
    }

    public void insertTx(Handle handle, ClusterModel cluster) {
        try (Update update = handle.createUpdate("insert into clusters (name, member_addresses, client_config_type, client_config, enabled, id) values (:name, :member_addresses, :client_config_type, :client_config, :enabled, :id)");){
            ((Update)((Update)((Update)((Update)((Update)((Update)update.bind("name", cluster.getName())).bind("member_addresses", (Object)cluster.getMemberAddresses())).bind("client_config_type", (Object)cluster.getClientConfigType())).bind("client_config", cluster.getClientConfig())).bind("enabled", cluster.isEnabled())).bind("id", cluster.getId())).execute();
        }
    }

    public int update(String name, ClusterModel cluster) {
        return (Integer)this.jdbi.withHandle(handle -> this.updateTx(handle, name, cluster));
    }

    public int updateTx(Handle handle, String name, ClusterModel cluster) {
        try (Update update = handle.createUpdate("UPDATE clusters SET member_addresses = :member_addresses, client_config_type = :client_config_type, client_config = :client_config, enabled = :enabled, id = :id WHERE name = :name");){
            int n = ((Update)((Update)((Update)((Update)((Update)((Update)update.bind("name", name)).bind("member_addresses", (Object)cluster.getMemberAddresses())).bind("client_config_type", (Object)cluster.getClientConfigType())).bind("client_config", cluster.getClientConfig())).bind("enabled", cluster.isEnabled())).bind("id", cluster.getId())).execute();
            return n;
        }
    }

    public void delete(String cluster) {
        this.jdbi.useHandle(handle -> this.deleteTx(handle, cluster));
    }

    public void deleteTx(Handle handle, String cluster) {
        try (Update update = handle.createUpdate("DELETE FROM clusters WHERE name = :name");){
            ((Update)update.bind("name", cluster)).execute();
        }
    }

    public Optional<ClusterModel> findByName(String name) {
        return (Optional)this.jdbi.withHandle(handle -> this.findByNameTx(handle, name));
    }

    public Optional<ClusterModel> findByNameTx(Handle handle, String name) {
        try (Query query = handle.createQuery("select * from clusters where name = :name");){
            Optional optional = ((Query)query.bind("name", name)).mapToBean(ClusterModel.class).findFirst();
            return optional;
        }
    }

    public List<String> findAllClusterNames() {
        return (List)this.jdbi.withHandle(handle -> {
            try (Query query = handle.createQuery("select name from clusters order by name");){
                List list = query.mapTo(String.class).list();
                return list;
            }
        });
    }

    public List<ClusterModel> findEnabled() {
        return (List)this.jdbi.withHandle(handle -> {
            try (Query query = handle.createQuery("select * from clusters where enabled = true order by name");){
                List list = query.mapToBean(ClusterModel.class).list();
                return list;
            }
        });
    }

    public int updateEnableStatus(String name, boolean enabled) {
        return (Integer)this.jdbi.withHandle(handle -> {
            try (Update update = handle.createUpdate("UPDATE clusters SET enabled = :enabled WHERE name = :name");){
                Integer n = ((Update)((Update)update.bind("name", name)).bind("enabled", enabled)).execute();
                return n;
            }
        });
    }

    public List<ClusterModel> findAllClusters() {
        return (List)this.jdbi.withHandle(handle -> {
            try (Query query = handle.createQuery("select * from clusters");){
                List list = query.mapToBean(ClusterModel.class).list();
                return list;
            }
        });
    }

    @ConstructorProperties(value={"jdbi"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ClusterDAO(Jdbi jdbi) {
        this.jdbi = jdbi;
    }
}

