/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.repositories.sql;

import com.hazelcast.webmonitor.model.sql.security.AuthTokenModel;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import org.springframework.stereotype.Repository;

@Repository
public class AuthTokenDAO {
    private final Jdbi jdbi;

    public Optional<AuthTokenModel> findByHash(String tokenHash) {
        return (Optional)this.jdbi.withHandle(handle -> {
            try (Query query = handle.createQuery("select * from auth_tokens where token_hash = :tokenHash");){
                Optional optional = ((Query)query.bind("tokenHash", tokenHash)).mapToBean(AuthTokenModel.class).findFirst();
                return optional;
            }
        });
    }

    public List<AuthTokenModel> findAllForUser(String username) {
        return (List)this.jdbi.withHandle(handle -> {
            try (Query query = handle.createQuery("select * from auth_tokens where username = :username");){
                List list = ((Query)query.bind("username", username)).mapToBean(AuthTokenModel.class).list();
                return list;
            }
        });
    }

    public List<AuthTokenModel> findAllTokens() {
        return (List)this.jdbi.withHandle(handle -> {
            try (Query query = handle.createQuery("select * from auth_tokens");){
                List list = query.mapToBean(AuthTokenModel.class).list();
                return list;
            }
        });
    }

    public void insert(AuthTokenModel token) {
        this.jdbi.withHandle(handle -> {
            try (Update update = handle.createUpdate("insert into auth_tokens (token_hash, token_id, username, label, roles, issued_at) values (:tokenHash, :tokenId, :username, :label, :roles, :issuedAt)");){
                Integer n = ((Update)update.bindBean((Object)token)).execute();
                return n;
            }
        });
    }

    public int revokeSingleToken(String tokenHash) {
        return (Integer)this.jdbi.withHandle(handle -> {
            try (Update update = handle.createUpdate("delete from auth_tokens where token_hash = :tokenHash");){
                Integer n = ((Update)update.bind("tokenHash", tokenHash)).execute();
                return n;
            }
        });
    }

    public int revokeTokenById(String tokenId) {
        return (Integer)this.jdbi.withHandle(handle -> {
            try (Update update = handle.createUpdate("delete from auth_tokens where token_id = :tokenId");){
                Integer n = ((Update)update.bind("tokenId", tokenId)).execute();
                return n;
            }
        });
    }

    public int revokeAllUserTokens(String username) {
        return (Integer)this.jdbi.withHandle(handle -> this.revokeAllUserTokensTx(handle, username));
    }

    public int revokeAllUserTokensTx(Handle handle, String username) {
        try (Update update = handle.createUpdate("delete from auth_tokens where username = :username");){
            int n = ((Update)update.bind("username", username)).execute();
            return n;
        }
    }

    public Optional<AuthTokenModel> findByTokenId(String tokenId) {
        return (Optional)this.jdbi.withHandle(handle -> {
            try (Query query = handle.createQuery("select * from auth_tokens where token_id = :tokenId");){
                Optional optional = ((Query)query.bind("tokenId", tokenId)).mapToBean(AuthTokenModel.class).findFirst();
                return optional;
            }
        });
    }

    public Optional<AuthTokenModel> findByLabelForUser(String username, String label) {
        return (Optional)this.jdbi.withHandle(handle -> {
            try (Query query = handle.createQuery("select * from auth_tokens where username = :username and label = :label");){
                Optional optional = ((Query)((Query)query.bind("username", username)).bind("label", label)).mapToBean(AuthTokenModel.class).findFirst();
                return optional;
            }
        });
    }

    @ConstructorProperties(value={"jdbi"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public AuthTokenDAO(Jdbi jdbi) {
        this.jdbi = jdbi;
    }
}

