/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.prometheus;

import com.hazelcast.jet.core.metrics.Unit;
import com.hazelcast.webmonitor.metrics.Tag;
import com.hazelcast.webmonitor.metrics.TagsBuilder;
import com.hazelcast.webmonitor.prometheus.EventReceiverProvider;
import com.hazelcast.webmonitor.prometheus.PrometheusEntry;
import com.hazelcast.webmonitor.service.MemberStateReceivedEvent;
import java.util.Map;

class SlowOperationProvider
extends EventReceiverProvider<MemberStateReceivedEvent> {
    private static final String SLOW_OPERATION_TOTAL_INVOCATIONS = "slow_operation_total_invocations";
    private static final String SLOW_OPERATION_INVOCATION_DURATION = "slow_operation_invocation_duration";

    protected SlowOperationProvider(long ttlInSeconds) {
        super((int)Math.min(ttlInSeconds, Integer.MAX_VALUE));
    }

    void updateResults(MemberStateReceivedEvent event) {
        event.getState().getMemberState().getOperationStats().getSlowOperations().forEach(operation -> {
            Map operationTags = TagsBuilder.tagsBuilder().with("mc_cluster", event.getSource().getClusterName()).with(Tag.MEMBER, event.getSource().getMemberAddress()).with(Tag.NAME, operation.getOperation()).buildStringMap();
            this.results.put((Object)new PrometheusEntry.Key(SLOW_OPERATION_TOTAL_INVOCATIONS, operationTags, "COUNT"), (Object)new PrometheusEntry.Value(event.getTimestamp(), (double)operation.getTotalInvocations()));
            operation.getInvocations().forEach(invocation -> {
                Map tags = TagsBuilder.tagsBuilderFrom((Map)operationTags).with(Tag.ID, String.valueOf(invocation.getId())).buildStringMap();
                this.results.put((Object)new PrometheusEntry.Key(SLOW_OPERATION_INVOCATION_DURATION, tags, Unit.MS.name()), (Object)new PrometheusEntry.Value(event.getTimestamp(), (double)invocation.getDurationMs()));
            });
        });
    }
}

