/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.prometheus;

import com.hazelcast.webmonitor.auditlog.AuditLogService;
import com.hazelcast.webmonitor.metrics.MetricsTraceLogger;
import com.hazelcast.webmonitor.prometheus.AuthenticatingPrometheusExporter;
import com.hazelcast.webmonitor.prometheus.ExporterJettyWebServerFactoryCustomizer;
import com.hazelcast.webmonitor.prometheus.PrometheusAuthDetailsStorage;
import com.hazelcast.webmonitor.prometheus.PrometheusExporter;
import com.hazelcast.webmonitor.prometheus.PrometheusExporterConfigurationProperties;
import com.hazelcast.webmonitor.prometheus.PrometheusExporterImpl;
import com.hazelcast.webmonitor.prometheus.PrometheusMetricPrinter;
import com.hazelcast.webmonitor.prometheus.PrometheusMetricsProvider;
import com.hazelcast.webmonitor.prometheus.PrometheusUsageTracker;
import com.hazelcast.webmonitor.service.telemetry.DataCollector;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={PrometheusExporterConfigurationProperties.class})
class PrometheusConfig {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PrometheusConfig.class);
    private final PrometheusExporterConfigurationProperties properties;

    @Bean
    ExporterJettyWebServerFactoryCustomizer webServerFactoryCustomizer(PrometheusExporter prometheusExporter) {
        return new ExporterJettyWebServerFactoryCustomizer(this.properties, prometheusExporter);
    }

    @Bean
    PrometheusExporter prometheusExporter(PrometheusAuthDetailsStorage authDetailsStorage, AuditLogService auditLog, MetricsTraceLogger metricsTraceLogger, List<PrometheusMetricsProvider> providers, List<PrometheusMetricPrinter> printers) {
        PrometheusExporterImpl prometheusExporterDefault = new PrometheusExporterImpl(this.properties.isEnabled(), metricsTraceLogger, providers, printers);
        return authDetailsStorage.getPrometheusAuthDetails().map(authDetails -> new AuthenticatingPrometheusExporter(prometheusExporterDefault, authDetails, auditLog)).orElse((PrometheusExporter)prometheusExporterDefault);
    }

    @Bean
    @ConditionalOnProperty(name={"hazelcast.mc.phone.home.enabled"}, matchIfMissing=true)
    DataCollector prometheusUsageTracker(PrometheusExporter prometheusExporter) {
        return new PrometheusUsageTracker(prometheusExporter);
    }

    @ConstructorProperties(value={"properties"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public PrometheusConfig(PrometheusExporterConfigurationProperties properties) {
        this.properties = properties;
    }
}

