/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.model;

import com.hazelcast.webmonitor.model.ClientAttributes;
import com.hazelcast.webmonitor.model.ClientAttributesParsingResult;
import com.hazelcast.webmonitor.utils.StringUtil;
import java.util.ArrayList;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

/*
 * Exception performing whole class analysis ignored.
 */
public final class ClientAttributesUtil {
    static final String CLIENT_TYPE = "clientType";
    static final String CLIENT_NAME = "clientName";
    static final String CLIENT_ADDRESS = "clientAddress";
    static final String CLIENT_VERSION = "clientVersion";
    static final String ENTERPRISE = "enterprise";
    static final String LAST_STATISTICS_COLLECTION_TIME = "lastStatisticsCollectionTime";
    static final String CLUSTER_CONNECTION_TIMESTAMP = "clusterConnectionTimestamp";
    static final Set<String> ATTRIBUTES_TO_POPULATE = Set.of("clientType", "clientName", "clientAddress", "clientVersion", "enterprise", "lastStatisticsCollectionTime", "clusterConnectionTimestamp");
    static final char STAT_SEPARATOR = ',';
    static final char KEY_VALUE_SEPARATOR = '=';
    static final char ESCAPE_CHAR = '\\';
    static final char[] DOUBLE_VALUE_MARKERS = new char[]{'.', 'e'};

    private ClientAttributesUtil() {
    }

    public static ClientAttributesParsingResult parseClientAttributes(String uuid, String statsAsString) {
        int index;
        if (StringUtil.isNullOrEmptyAfterTrim((String)statsAsString)) {
            return new ClientAttributesParsingResult(ClientAttributes.EMPTY, "Empty stat string for client with UUID: %s.".formatted(uuid));
        }
        char[] charArray = statsAsString.toCharArray();
        int wantedAttributesParsedCount = 0;
        int strStart = 0;
        String currentAttributeName = "";
        boolean attributeNameIsParsed = false;
        int previousChar = 97;
        ClientAttributes clientAttributes = new ClientAttributes();
        ArrayList<String> malformedKeyValuePairs = new ArrayList<String>();
        for (index = 0; index < charArray.length; ++index) {
            int currentChar = charArray[index];
            if (currentChar == 61 && previousChar != 92) {
                currentAttributeName = ClientAttributesUtil.toString((char[])charArray, (int)strStart, (int)index);
                attributeNameIsParsed = true;
                strStart = index + 1;
            } else if (currentChar == 44 && previousChar != 92) {
                if (attributeNameIsParsed) {
                    if (ATTRIBUTES_TO_POPULATE.contains(currentAttributeName)) {
                        if (index > strStart) {
                            ClientAttributesUtil.populateClientAttribute((ClientAttributes)clientAttributes, (String)currentAttributeName, (String)ClientAttributesUtil.toString((char[])charArray, (int)strStart, (int)index));
                        }
                        if (++wantedAttributesParsedCount == ATTRIBUTES_TO_POPULATE.size()) {
                            break;
                        }
                    } else if (StringUtil.isNullOrEmptyAfterTrim((String)currentAttributeName)) {
                        int offsetWithSeparator = strStart - 1;
                        malformedKeyValuePairs.add(ClientAttributesUtil.toString((char[])charArray, (int)offsetWithSeparator, (int)index));
                    }
                    attributeNameIsParsed = false;
                } else {
                    malformedKeyValuePairs.add(ClientAttributesUtil.toString((char[])charArray, (int)strStart, (int)index));
                }
                strStart = index + 1;
            }
            previousChar = currentChar;
        }
        if (index == strStart && !attributeNameIsParsed) {
            malformedKeyValuePairs.add("");
        }
        if (index > strStart) {
            if (attributeNameIsParsed) {
                if (StringUtil.isNullOrEmptyAfterTrim((String)currentAttributeName)) {
                    int offsetWithSeparator = strStart - 1;
                    malformedKeyValuePairs.add(ClientAttributesUtil.toString((char[])charArray, (int)offsetWithSeparator, (int)index));
                }
                ClientAttributesUtil.populateClientAttribute((ClientAttributes)clientAttributes, (String)currentAttributeName, (String)ClientAttributesUtil.toString((char[])charArray, (int)strStart, (int)index));
            } else {
                malformedKeyValuePairs.add(ClientAttributesUtil.toString((char[])charArray, (int)strStart, (int)index));
            }
        }
        String parsingError = null;
        if (!malformedKeyValuePairs.isEmpty()) {
            parsingError = String.format("Failed to parse client stats key/value pairs: %s, for client with UUID: %s.", malformedKeyValuePairs, uuid);
        }
        return new ClientAttributesParsingResult(clientAttributes, parsingError);
    }

    private static void populateClientAttribute(ClientAttributes clientAttributes, String statName, String statValue) {
        switch (statName) {
            case "clientType": {
                clientAttributes.setType(statValue);
                break;
            }
            case "clientName": {
                clientAttributes.setName(statValue);
                break;
            }
            case "clientAddress": {
                clientAttributes.setAddress(statValue);
                break;
            }
            case "clientVersion": {
                clientAttributes.setVersion(statValue);
                break;
            }
            case "enterprise": {
                clientAttributes.setEnterprise(Boolean.valueOf(statValue));
                break;
            }
            case "lastStatisticsCollectionTime": {
                break;
            }
            case "clusterConnectionTimestamp": {
                clientAttributes.setClusterConnectionTimestamp(ClientAttributesUtil.toLong((String)statValue));
                break;
            }
        }
    }

    @NotNull
    private static String toString(char[] charArray, int strStart, int index) {
        return new String(charArray, strStart, index - strStart);
    }

    @NotNull
    private static Long toLong(String statText) {
        if (StringUtils.containsAny((CharSequence)statText, (char[])DOUBLE_VALUE_MARKERS)) {
            return Math.round(Double.parseDouble(statText));
        }
        return Long.valueOf(statText);
    }
}

