/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.metrics.jet.tsdb;

import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.webmonitor.metrics.Tag;
import com.hazelcast.webmonitor.metrics.jet.TimeSeriesSlice;
import com.hazelcast.webmonitor.metrics.jet.tsdb.TimeSeries;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;

/*
 * Exception performing whole class analysis ignored.
 */
public class TimeSeriesImpl
implements TimeSeries {
    public static final TimeSeriesImpl EMPTY_TIMESERIES = new TimeSeriesImpl(Collections.emptyMap(), 1000L, 0);
    private final Map<String, String> tags;
    private final long interval;
    private long startSequence;
    private long endSequence;
    private final long[] values;

    public TimeSeriesImpl(Map<String, String> tags, long interval, int numberOfPoints) {
        Preconditions.checkPositive((float)interval, (String)("interval=" + interval));
        this.interval = interval;
        this.values = new long[numberOfPoints];
        this.tags = tags;
    }

    static long interpolate(long a, long b, long d) {
        if (b == 0L) {
            throw new IllegalArgumentException("b == 0");
        }
        if (a == b) {
            return d;
        }
        if (a == 0L || d == 0L) {
            return 0L;
        }
        try {
            return Math.multiplyExact(a, d) / b;
        }
        catch (ArithmeticException e) {
            return TimeSeriesImpl.clampToLong((BigInteger)BigInteger.valueOf(a).multiply(BigInteger.valueOf(d)).divide(BigInteger.valueOf(b)));
        }
    }

    private static long clampToLong(BigInteger val) {
        if (val.bitLength() <= 63) {
            return val.longValueExact();
        }
        return val.signum() == 1 ? Long.MAX_VALUE : Long.MIN_VALUE;
    }

    public void storePoint(long timestamp, long value) {
        long thisSequenceI = timestamp / this.interval;
        if (Math.floorMod(timestamp, this.interval) >= this.interval / 2L) {
            ++thisSequenceI;
        }
        if (this.startSequence == this.endSequence) {
            this.values[this.toIndex((long)thisSequenceI)] = value;
            this.startSequence = thisSequenceI;
            this.endSequence = thisSequenceI + 1L;
            return;
        }
        if (thisSequenceI >= this.startSequence && thisSequenceI < this.endSequence) {
            this.values[this.toIndex((long)thisSequenceI)] = value;
        }
        if (thisSequenceI >= this.endSequence) {
            long newestValueSeq = this.endSequence - 1L;
            long newestValue = this.values[this.toIndex(newestValueSeq)];
            this.endSequence = Math.max(thisSequenceI - (long)this.values.length + 1L, this.endSequence);
            this.values[this.toIndex((long)thisSequenceI)] = value;
            int index = this.toIndex(this.endSequence);
            while (thisSequenceI > this.endSequence) {
                this.values[index] = newestValue + TimeSeriesImpl.interpolate((long)(this.endSequence - newestValueSeq), (long)(thisSequenceI - newestValueSeq), (long)(value - newestValue));
                ++this.endSequence;
                index = this.toIndexSimple(index + 1);
            }
            ++this.endSequence;
            this.startSequence = Math.max(this.startSequence, this.endSequence - (long)this.values.length);
        }
        if (this.endSequence - this.startSequence < (long)this.values.length) {
            long oldestValueSeq = this.startSequence;
            long oldestValue = this.values[this.toIndex(oldestValueSeq)];
            long newStartSequence = Math.max(this.endSequence - (long)this.values.length, thisSequenceI);
            int index = this.toIndex(this.startSequence - 1L);
            while (this.startSequence > newStartSequence && index > 0) {
                this.values[index] = oldestValue + TimeSeriesImpl.interpolate((long)(this.startSequence - 1L - oldestValueSeq), (long)(thisSequenceI - oldestValueSeq), (long)(value - oldestValue));
                --this.startSequence;
                index = this.toIndexSimple(index - 1);
            }
        }
    }

    public long query(long timestamp, long noValueMarker) {
        long thisSequenceI = timestamp / this.interval;
        if (thisSequenceI < this.startSequence || thisSequenceI >= this.endSequence) {
            return noValueMarker;
        }
        return this.values[this.toIndex(thisSequenceI)];
    }

    public TimeSeriesSlice queryRange(long startTs, long endTs, long noValueMarker) {
        if (endTs < startTs) {
            throw new IllegalArgumentException("Negative range");
        }
        long startSeq = startTs / this.interval;
        long endSeq = endTs / this.interval;
        assert (endSeq - startSeq <= Integer.MAX_VALUE) : "too many values";
        long[] res = new long[(int)(endSeq - startSeq)];
        int offset = 0;
        if (this.startSequence == this.endSequence) {
            Arrays.fill(res, noValueMarker);
            return new TimeSeriesSlice(this.tags, this.interval, startTs, noValueMarker, res);
        }
        if (startSeq < this.startSequence) {
            offset += Math.min((int)(this.startSequence - startSeq), res.length);
            if (noValueMarker != 0L) {
                Arrays.fill(res, 0, offset, noValueMarker);
            }
            startSeq = this.startSequence;
        }
        if (startSeq >= endSeq) {
            return new TimeSeriesSlice(this.tags, this.interval, startTs, noValueMarker, res);
        }
        if (startSeq < this.endSequence) {
            int endIndex;
            int startIndex = this.toIndex(startSeq);
            if (startIndex < (endIndex = this.toIndex(Math.min(endSeq, this.endSequence)))) {
                System.arraycopy(this.values, startIndex, res, offset, endIndex - startIndex);
                offset += endIndex - startIndex;
            } else {
                System.arraycopy(this.values, startIndex, res, offset, this.values.length - startIndex);
                System.arraycopy(this.values, 0, res, offset += this.values.length - startIndex, endIndex);
                offset += endIndex;
            }
        }
        if (endSeq > this.endSequence) {
            assert ((long)(res.length - offset) <= endSeq - this.endSequence) : "res.length=" + res.length + ", offset=" + offset + ", endSeq=" + endSeq + ", this.endSequence=" + this.endSequence;
            if (noValueMarker != 0L) {
                Arrays.fill(res, offset, res.length, noValueMarker);
            }
        }
        return new TimeSeriesSlice(this.tags, this.interval, startTs, noValueMarker, res);
    }

    public long queryLast(long noValueMarker) {
        if (this.endSequence == this.startSequence) {
            return noValueMarker;
        }
        return this.values[this.toIndex(this.endSequence - 1L)];
    }

    public long getLatestTime() {
        return (this.endSequence - 1L) * this.interval;
    }

    public long interval() {
        return this.interval;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public String metric() {
        return (String)this.tags.get(Tag.METRIC.getName());
    }

    public int size() {
        return this.values.length;
    }

    private int toIndex(long sequence) {
        return (int)Math.floorMod(sequence, (long)this.values.length);
    }

    private int toIndexSimple(int index) {
        assert (index >= 0 && index < 2 * this.values.length) : "index=" + index + ", values.length=" + this.values.length;
        if (index >= this.values.length) {
            return index - this.values.length;
        }
        return index;
    }

    public String toString() {
        return "TimeSeriesImpl{tags=" + String.valueOf(this.tags) + ", interval=" + this.interval + ", startSequence=" + this.startSequence + ", endSequence=" + this.endSequence + ", values=" + Arrays.toString(this.values) + "}";
    }
}

