/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.metrics.jet;

import com.hazelcast.webmonitor.metrics.jet.McMetricsUtil;
import com.hazelcast.webmonitor.metrics.jet.TimeSeriesSingleValue;
import com.hazelcast.webmonitor.metrics.jet.TimeSeriesSlice;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public class TimeSeriesSlice {
    private final Map<String, String> tags;
    private final long startTs;
    private final long[] series;
    private final long noValueMarker;
    private final long interval;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public TimeSeriesSlice(Map<String, String> tags, long interval, long startTs, long noValueMarker, long[] series) {
        this.tags = tags;
        this.startTs = startTs;
        this.series = series;
        this.noValueMarker = noValueMarker;
        this.interval = interval;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public long[] getSeries() {
        return this.series;
    }

    public long getStartTs() {
        return this.startTs;
    }

    public int size() {
        return this.series.length;
    }

    public long noValueMarker() {
        return this.noValueMarker;
    }

    public long getInterval() {
        return this.interval;
    }

    public Optional<TimeSeriesSingleValue> getLatestValue() {
        long latestValue = this.noValueMarker;
        for (int i = this.series.length - 1; i > 0; --i) {
            if (this.series[i] == this.noValueMarker) continue;
            latestValue = this.series[i];
            break;
        }
        if (latestValue == this.noValueMarker) {
            return Optional.empty();
        }
        return Optional.of(TimeSeriesSingleValue.builder().tags(this.tags).value(latestValue).build());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("TimeSeriesSlice{tags=").append(this.tags).append(", startTs=").append(this.startTs).append(", series=[");
        for (int i = 0; i < 20 && i < this.series.length; ++i) {
            sb.append(this.series[i]).append(", ");
        }
        if (this.series.length > 20) {
            sb.append("...]");
        } else {
            if (this.series.length > 0) {
                sb.setLength(sb.length() - 2);
            }
            sb.append(']');
        }
        return sb.toString();
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeSeriesSlice that = (TimeSeriesSlice)o;
        return this.startTs == that.startTs && this.noValueMarker == that.noValueMarker && this.interval == that.interval && Objects.equals(this.tags, that.tags) && Arrays.equals(this.series, that.series);
    }

    public int hashCode() {
        int result = Objects.hash(this.tags, this.startTs, this.noValueMarker, this.interval);
        result = 31 * result + Arrays.hashCode(this.series);
        return result;
    }

    public static Collector<TimeSeriesSlice, ?, TimeSeriesSlice> toAverage() {
        return Collector.of(SumAndCountAccumulator::new, SumAndCountAccumulator::accumulate, SumAndCountAccumulator::combine, SumAndCountAccumulator::toAverages, Collector.Characteristics.UNORDERED);
    }

    public static Collector<TimeSeriesSlice, ?, TimeSeriesSlice> toSum() {
        return Collector.of(SumAndCountAccumulator::new, SumAndCountAccumulator::accumulate, SumAndCountAccumulator::combine, SumAndCountAccumulator::toSums, Collector.Characteristics.UNORDERED);
    }

    public static Collector<TimeSeriesSlice, ?, Collection<TimeSeriesSlice>> tagGrouping(Collector<TimeSeriesSlice, ?, TimeSeriesSlice> inGroupCollector, String ... groupingTags) {
        Set<String> groupingTagsSet = Set.of(groupingTags);
        Collector<TimeSeriesSlice, ?, Map<String, TimeSeriesSlice>> collector = Collectors.groupingBy(tss -> McMetricsUtil.tagsGroupingKey((Map)tss.tags(), (Set)groupingTagsSet), inGroupCollector);
        return Collectors.collectingAndThen(collector, Map::values);
    }

    private static void checkRanges(TimeSeriesSlice s1, TimeSeriesSlice s2) {
        if (s2.size() != s1.size() || s2.startTs != s1.startTs || s2.interval != s1.interval) {
            throw new IllegalArgumentException("Slices have different range: size1=" + s1.size() + ", size2=" + s2.size() + ", startTs1=" + s1.startTs + ", startTs2=" + s2.startTs + ", interval1=" + s1.interval + ", interval2=" + s2.interval);
        }
    }
}

