/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.metrics.jet;

import com.google.common.annotations.VisibleForTesting;
import com.hazelcast.cluster.Member;
import com.hazelcast.webmonitor.metrics.MetricDataPoint;
import com.hazelcast.webmonitor.metrics.Tag;
import com.hazelcast.webmonitor.metrics.jet.tagexpressions.EqualsExpression;
import com.hazelcast.webmonitor.metrics.jet.tagexpressions.TagExpression;
import com.hazelcast.webmonitor.metrics.jet.tagexpressions.TagExpressions;
import com.hazelcast.webmonitor.metrics.jet.tsdb.SynchronizedTimeSeries;
import com.hazelcast.webmonitor.metrics.jet.tsdb.TimeSeries;
import com.hazelcast.webmonitor.metrics.jet.tsdb.TimeSeriesImpl;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JetClusterMetricsStore {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JetClusterMetricsStore.class);
    public static final long DEFAULT_METRICS_INTERVAL = 1000L;
    private final ConcurrentMap<String, ConcurrentMap<String, TimeSeries>> metrics = new ConcurrentHashMap();
    private static final long INTERVAL = 1000L;
    private final int numberOfPoints;
    private final ConcurrentMap<Member, Long> latestSeenTimestamps = new ConcurrentHashMap();

    @VisibleForTesting
    JetClusterMetricsStore() {
        this.numberOfPoints = 3600;
    }

    public JetClusterMetricsStore(int numberOfPoints) {
        this.numberOfPoints = numberOfPoints;
    }

    public Stream<TimeSeries> query(String metric, TagExpression filter) {
        Map map = (Map)this.metrics.get(metric);
        if (map == null) {
            return Stream.empty();
        }
        return map.values().stream().filter(ts -> filter.matches(ts.tags()));
    }

    public Stream<TimeSeries> query(String metric) {
        return this.query(metric, TagExpressions.any());
    }

    public TimeSeries querySingle(String metric, TagExpression filter) {
        return (TimeSeries)this.query(metric, filter).reduce((o, n) -> {
            throw new RuntimeException("Multiple metrics found for metric=" + metric + "filter=" + String.valueOf(filter));
        }).orElse(TimeSeriesImpl.EMPTY_TIMESERIES);
    }

    public void removeMember(Member member) {
        log.debug("Removing metrics for " + String.valueOf(member) + " from store");
        EqualsExpression expr = TagExpressions.tagEquals((String)"member", (String)member.getUuid().toString());
        this.metrics.values().forEach(arg_0 -> JetClusterMetricsStore.lambda$removeMember$3((TagExpression)expr, arg_0));
    }

    public void storeMetricsCollection(Member member, List<MetricDataPoint> metricDataPoints) {
        if (metricDataPoints.isEmpty()) {
            return;
        }
        for (MetricDataPoint metricDataPoint : metricDataPoints) {
            Object2ObjectArrayMap tags = new Object2ObjectArrayMap(metricDataPoint.getTags());
            if (!"jet".equals(tags.remove("module"))) continue;
            String name = metricDataPoint.getName();
            tags.put(Tag.METRIC.getName(), name);
            tags.put("member", member.getUuid().toString());
            tags.put("address", member.getAddress().toString());
            long time = metricDataPoint.getTime();
            this.metrics.computeIfAbsent(name, k -> new ConcurrentHashMap()).computeIfAbsent(tags.toString(), arg_0 -> this.lambda$storeMetricsCollection$5((Map)tags, arg_0)).storePoint(time, metricDataPoint.getValue());
        }
        long latestTimestamp = metricDataPoints.stream().map(MetricDataPoint::getTime).max(Long::compareTo).orElseThrow(IllegalStateException::new);
        Long prev = this.latestSeenTimestamps.put(member, latestTimestamp);
        if (prev != null) {
            if (prev >= latestTimestamp) {
                log.warn("Received non-monotonic timestamp from {}. previous={} current={}", new Object[]{member, prev, latestTimestamp});
                return;
            }
            EqualsExpression expr = TagExpressions.tagEquals((String)"member", (String)member.getUuid().toString());
            this.metrics.values().forEach(arg_0 -> JetClusterMetricsStore.lambda$storeMetricsCollection$7(latestTimestamp, (TagExpression)expr, arg_0));
        }
    }

    private static /* synthetic */ void lambda$storeMetricsCollection$7(long latestTimestamp, TagExpression expr, ConcurrentMap m) {
        m.values().removeIf(ts -> ts.getLatestTime() + 1000L < latestTimestamp && expr.matches(ts.tags()));
    }

    private /* synthetic */ TimeSeries lambda$storeMetricsCollection$5(Map tags, String k) {
        return new SynchronizedTimeSeries((TimeSeries)new TimeSeriesImpl(tags, 1000L, this.numberOfPoints));
    }

    private static /* synthetic */ void lambda$removeMember$3(TagExpression expr, ConcurrentMap m) {
        m.values().removeIf(ts -> expr.matches(ts.tags()));
    }
}

