/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.metrics.impl.rocksdb;

import com.hazelcast.internal.metrics.managementcenter.ConcurrentArrayRingbuffer;
import com.hazelcast.webmonitor.metrics.impl.rocksdb.DataPointMemoryCompressionTracker;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAccumulator;
import java.util.concurrent.atomic.LongAdder;
import lombok.Generated;

/*
 * Exception performing whole class analysis ignored.
 */
class RocksDBMetricsStorageStatsCounter {
    static final int MOVING_AVERAGE_WINDOW = (int)TimeUnit.HOURS.toSeconds(1L) / 10;
    private final ConcurrentArrayRingbuffer<Long> lastHourPersistenceRunTimes = new ConcurrentArrayRingbuffer(MOVING_AVERAGE_WINDOW);
    private final ConcurrentArrayRingbuffer<Long> lastHourPersistedMinuteBucketsCounts = new ConcurrentArrayRingbuffer(MOVING_AVERAGE_WINDOW);
    private final LongAdder persistenceRunTimeCounter = new LongAdder();
    private final LongAdder persistenceRunsCounter = new LongAdder();
    private final LongAdder droppedDataPoints = new LongAdder();
    private final LongAdder evictedDanglingMinuteSeries = new LongAdder();
    private final LongAccumulator maxPersistedMinuteBucketsPerRun = new LongAccumulator(Long::max, 0L);
    private final LongAccumulator maxPersistenceRunTimeInMs = new LongAccumulator(Long::max, 0L);
    private final DataPointMemoryCompressionTracker dataPointMemoryCompressionTracker = new DataPointMemoryCompressionTracker();

    RocksDBMetricsStorageStatsCounter() {
    }

    void accumulatePersistenceRunData(long x, long ms) {
        this.lastHourPersistedMinuteBucketsCounts.add((Object)x);
        this.maxPersistedMinuteBucketsPerRun.accumulate(x);
        this.persistenceRunTimeCounter.add(ms);
        this.lastHourPersistenceRunTimes.add((Object)ms);
        this.maxPersistenceRunTimeInMs.accumulate(ms);
        this.persistenceRunsCounter.increment();
    }

    void incrementDroppedDataPoints() {
        this.droppedDataPoints.increment();
    }

    void incrementEvictedDanglingMinuteSeries() {
        this.evictedDanglingMinuteSeries.increment();
    }

    long persistenceRuns() {
        return this.persistenceRunsCounter.sum();
    }

    long totalPersistenceRunTimeInMs() {
        return this.persistenceRunTimeCounter.sum();
    }

    long maxPersistenceRunTimeInMs() {
        return this.maxPersistenceRunTimeInMs.get();
    }

    long lastHourAvgPersistedMinuteBucketsPerRun() {
        return RocksDBMetricsStorageStatsCounter.getAvg((ConcurrentArrayRingbuffer)this.lastHourPersistedMinuteBucketsCounts);
    }

    long avgPersistenceRunTimeInMs() {
        return this.divideToPersistenceRunsOrZero(this.persistenceRunTimeCounter.sum());
    }

    long lastHourAvgPersistenceRunTimeInMs() {
        return RocksDBMetricsStorageStatsCounter.getAvg((ConcurrentArrayRingbuffer)this.lastHourPersistenceRunTimes);
    }

    long maxPersistedMinuteBucketsPerRun() {
        return this.maxPersistedMinuteBucketsPerRun.get();
    }

    long avgPersistedMinuteBucketsPerRun(long totalPersistedMinuteBuckets) {
        return this.divideToPersistenceRunsOrZero(totalPersistedMinuteBuckets);
    }

    long totalDroppedDataPoints() {
        return this.droppedDataPoints.sum();
    }

    long totalEvictedDanglingMinuteSeries() {
        return this.evictedDanglingMinuteSeries.sum();
    }

    static long getAvg(ConcurrentArrayRingbuffer<Long> buffer) {
        return (long)buffer.copyFrom(0L).stream().mapToLong(Long::longValue).average().orElse(0.0);
    }

    long divideToPersistenceRunsOrZero(long number) {
        long persistenceRuns = this.persistenceRunsCounter.sum();
        if (persistenceRuns == 0L) {
            return 0L;
        }
        return number / persistenceRuns;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public DataPointMemoryCompressionTracker getDataPointMemoryCompressionTracker() {
        return this.dataPointMemoryCompressionTracker;
    }
}

