/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.metrics.impl.rocksdb;

import com.hazelcast.webmonitor.controller.dto.metrics.storage.MetricsStorageDiagnosticsDTO;
import com.hazelcast.webmonitor.metrics.impl.rocksdb.RocksDBMetricsStorageStatsSupplier;
import com.hazelcast.webmonitor.model.telemetry.PhoneHomeData;
import com.hazelcast.webmonitor.service.telemetry.DataCollector;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import lombok.Generated;

class RocksDBMetricsStorageStatsCollector
implements DataCollector {
    private final RocksDBMetricsStorageStatsSupplier diagnosticsDataSupplier;

    public void collectInto(PhoneHomeData data) {
        MetricsStorageDiagnosticsDTO stats = this.diagnosticsDataSupplier.get();
        data.setMetricsStorageSize(stats.getStorageSizeInBytes());
        data.setMetricsStorageRetentionSeconds(stats.getPersistentStoreTTLSeconds());
        double metricsDataPointCompressionRate = stats.getDataPointMemoryCompressionRatio();
        if (!Double.isNaN(metricsDataPointCompressionRate)) {
            data.setMetricsDataPointCompressionRate(metricsDataPointCompressionRate);
        }
        data.setMetricsStorageKnownTimeSeries(stats.getKnownTimeSeries());
        data.setMetricsStorageTrackedMinuteBuckets(stats.getTrackedMinuteBuckets());
        data.setMetricsStoragePersistenceRuns(stats.getPersistenceRuns());
        data.setMetricsStorageTotalPersistenceRunTimeInMs(stats.getTotalPersistenceRunTimeInMs());
        data.setMetricsStorageMaxPersistenceRunTimeInMs(stats.getMaxPersistenceRunTimeInMs());
        data.setMetricsStorageAvgPersistenceRunTimeInMs(stats.getAvgPersistenceRunTimeInMs());
        data.setMetricsStorageLastHourAvgPersistenceRunTimeInMs(stats.getLastHourAvgPersistenceRunTimeInMs());
        data.setMetricsStorageTotalPersistedMinuteBuckets(stats.getTotalPersistedMinuteBuckets());
        data.setMetricsStorageMaxPersistedMinuteBucketsPerRun(stats.getMaxPersistedMinuteBucketsPerRun());
        data.setMetricsStorageAvgPersistedMinuteBucketsPerRun(stats.getAvgPersistedMinuteBucketsPerRun());
        data.setMetricsStorageLastHourAvgPersistedMinuteBucketsPerRun(stats.getLastHourAvgPersistedMinuteBucketsPerRun());
        data.setMetricsStorageTotalDroppedDataPoints(stats.getTotalDroppedDataPoints());
        data.setMetricsStorageTotalEvictedDanglingMinuteSeries(stats.getTotalEvictedDanglingMinuteSeries());
    }

    @ConstructorProperties(value={"diagnosticsDataSupplier"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public RocksDBMetricsStorageStatsCollector(RocksDBMetricsStorageStatsSupplier diagnosticsDataSupplier) {
        this.diagnosticsDataSupplier = diagnosticsDataSupplier;
    }
}

