/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.metrics.impl.rocksdb;

import com.hazelcast.webmonitor.metrics.impl.rocksdb.MinuteSeries;
import com.hazelcast.webmonitor.metrics.impl.rocksdb.MinuteStartId;
import com.hazelcast.webmonitor.metrics.impl.rocksdb.RocksDBTimeUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.concurrent.atomic.AtomicLongArray;
import lombok.Generated;

class MinuteBucket {
    final AtomicLongArray values = new AtomicLongArray(60);
    final int metricId;
    volatile long minuteStart;
    boolean untracked = true;
    boolean released = true;
    final MinuteSeries minuteSeries;

    MinuteBucket(int metricId, MinuteSeries minuteSeries) {
        this.metricId = metricId;
        this.minuteSeries = minuteSeries;
        this.resetValues();
    }

    void put(long time, long value) {
        int offset = RocksDBTimeUtil.minuteOffset((long)time);
        this.values.set(offset, value);
    }

    void putIfAvailable(long time, long value) {
        if (!this.released || !this.untracked) {
            throw new IllegalStateException("Minute bucket is not available");
        }
        this.released = false;
        this.untracked = false;
        this.minuteStart = RocksDBTimeUtil.minuteStart((long)time);
        this.put(time, value);
    }

    MinuteStartId minStartId() {
        return new MinuteStartId(this.metricId, this.minuteStart);
    }

    long[] values() {
        long[] result = new long[this.values.length()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.values.get(i);
        }
        return result;
    }

    AtomicLongArray rawValues() {
        return this.values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void release() {
        MinuteSeries minuteSeries = this.minuteSeries;
        synchronized (minuteSeries) {
            this.minuteSeries.removeBucketIfSizeExceeds(this);
            this.resetValues();
            this.released = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void untrack() {
        MinuteSeries minuteSeries = this.minuteSeries;
        synchronized (minuteSeries) {
            this.untracked = true;
        }
    }

    private void resetValues() {
        for (int i = 0; i < this.values.length(); ++i) {
            this.values.set(i, Long.MIN_VALUE);
        }
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MinuteBucket)) {
            return false;
        }
        MinuteBucket other = (MinuteBucket)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.metricId != other.metricId) {
            return false;
        }
        return this.minuteStart == other.minuteStart;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MinuteBucket;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.metricId;
        long $minuteStart = this.minuteStart;
        result = result * 59 + (int)($minuteStart >>> 32 ^ $minuteStart);
        return result;
    }
}

