/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.metrics.aggregation;

import com.hazelcast.webmonitor.metrics.DataPointAware;
import com.hazelcast.webmonitor.metrics.DataPointSeries;
import com.hazelcast.webmonitor.metrics.DataPointType;
import com.hazelcast.webmonitor.metrics.aggregation.Aggregator;
import com.hazelcast.webmonitor.metrics.aggregation.MetricType;
import java.util.Iterator;

public final class DiffPerSecondAggregator
implements Aggregator {
    private final DataPointSeries series;

    public DiffPerSecondAggregator(DataPointSeries series) {
        this.series = series;
    }

    public DataPointSeries compute() {
        if (this.series.size() < 2) {
            return DataPointSeries.empty();
        }
        int size = this.series.size() - 1;
        long[] times = new long[size];
        long[] values = new long[size];
        Iterator iter = this.series.iterator();
        DataPointAware prevPoint = (DataPointAware)iter.next();
        for (int i = 0; i < size; ++i) {
            DataPointAware point = (DataPointAware)iter.next();
            times[i] = point.getTime();
            int intervalSec = (int)(point.getTime() - prevPoint.getTime()) / 1000;
            values[i] = MetricType.from((DataPointType)this.series.getType()).diffPerSec(point.getValue(), prevPoint.getValue(), intervalSec);
            prevPoint = point;
        }
        return new DataPointSeries(times, values, DataPointType.DOUBLE);
    }
}

