/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.metrics;

import com.hazelcast.webmonitor.metrics.DataPointsReceivedEvent;
import com.hazelcast.webmonitor.metrics.MetricDataPoint;
import com.hazelcast.webmonitor.metrics.MetricDataPointProcessor;
import com.hazelcast.webmonitor.metrics.MultipleMetricDataPointsProcessor;
import com.hazelcast.webmonitor.service.MemberIdentifier;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.List;
import lombok.Generated;
import org.springframework.context.ApplicationListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class MetricsProcessor
implements ApplicationListener<DataPointsReceivedEvent> {
    private final List<MetricDataPointProcessor> metricsProcessors;
    private final List<MultipleMetricDataPointsProcessor> multipleMetricsProcessors;

    @Async
    public void onApplicationEvent(DataPointsReceivedEvent event) {
        MemberIdentifier memberIdent = event.getMemberIdent();
        List dataPoints = event.getDataPoints();
        for (MetricDataPoint dataPoint : dataPoints) {
            for (MetricDataPointProcessor processor : this.metricsProcessors) {
                if (!processor.shouldProcessDataPoint(dataPoint)) continue;
                processor.processDataPoint(dataPoint, memberIdent);
            }
        }
        for (MultipleMetricDataPointsProcessor multipleMetricsProcessor : this.multipleMetricsProcessors) {
            List<MetricDataPoint> filteredPoints = dataPoints.stream().filter(arg_0 -> ((MultipleMetricDataPointsProcessor)multipleMetricsProcessor).shouldProcessDataPoint(arg_0)).toList();
            multipleMetricsProcessor.processDataPoints(filteredPoints, memberIdent);
        }
    }

    @ConstructorProperties(value={"metricsProcessors", "multipleMetricsProcessors"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public MetricsProcessor(List<MetricDataPointProcessor> metricsProcessors, List<MultipleMetricDataPointsProcessor> multipleMetricsProcessors) {
        this.metricsProcessors = metricsProcessors;
        this.multipleMetricsProcessors = multipleMetricsProcessors;
    }
}

