/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.events;

import com.google.common.collect.EvictingQueue;
import com.hazelcast.webmonitor.events.EventPublishingVisitor;
import com.hazelcast.webmonitor.events.EventVisitor;
import com.hazelcast.webmonitor.events.model.AbstractWanEvent;
import com.hazelcast.webmonitor.service.Clock;
import com.hazelcast.webmonitor.service.ClusterRemovedEvent;
import com.hazelcast.webmonitor.utils.ExecutorServiceShutdownUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;

@Service
public class WanEventStore
implements AutoCloseable,
InitializingBean {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WanEventStore.class);
    public static final int DEFAULT_MAX_EVENTS_PER_CLUSTER = 10000;
    public static final Duration DEFAULT_CLEANUP_DELAY = Duration.ofHours(1L);
    private static final AbstractWanEvent[] EMPTY_WAN_EVENTS = new AbstractWanEvent[0];
    private final Map<String, EvictingQueue<AbstractWanEvent>> store = new HashMap();
    private final Map<String, Long> lastUpdated = new HashMap();
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final Lock rLock = this.rwLock.readLock();
    private final Lock wLock = this.rwLock.writeLock();
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, "WanEventStoreCleanup"));
    private final EventPublishingVisitor eventPublishingVisitor;
    private final int maxEventsPerCluster;
    private final Clock clock;

    @Autowired
    public WanEventStore(EventPublishingVisitor eventPublishingVisitor, Clock clock) {
        this(eventPublishingVisitor, 10000, clock);
    }

    public void afterPropertiesSet() {
        this.executor.scheduleWithFixedDelay(() -> this.cleanUpStore(), DEFAULT_CLEANUP_DELAY.toHours(), DEFAULT_CLEANUP_DELAY.toHours(), TimeUnit.HOURS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanUpStore() {
        Set<String> clustersToBeRemoved;
        long oldestTimestampAllowed = this.clock.currentTimeMillis() - DEFAULT_CLEANUP_DELAY.toMillis();
        this.wLock.lock();
        try {
            clustersToBeRemoved = this.lastUpdated.entrySet().stream().filter(entry -> (Long)entry.getValue() < oldestTimestampAllowed).map(Map.Entry::getKey).collect(Collectors.toSet());
            clustersToBeRemoved.forEach(cluster -> {
                this.store.remove(cluster);
                this.lastUpdated.remove(cluster);
            });
        }
        finally {
            this.wLock.unlock();
        }
        if (!clustersToBeRemoved.isEmpty()) {
            log.info("Events for the following clusters are being deleted as no events have been received from them since {} : {}.", (Object)LocalDateTime.ofInstant(Instant.ofEpochMilli(oldestTimestampAllowed), TimeZone.getDefault().toZoneId()), clustersToBeRemoved);
        }
    }

    @EventListener
    public void cleanUpRemovedCluster(ClusterRemovedEvent event) {
        String cluster = event.getCluster();
        this.wLock.lock();
        try {
            this.store.remove(cluster);
            this.lastUpdated.remove(cluster);
        }
        finally {
            this.wLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(String cluster, List<AbstractWanEvent> events) {
        this.wLock.lock();
        try {
            this.lastUpdated.put(cluster, this.clock.currentTimeMillis());
            EvictingQueue eventQueue = this.store.getOrDefault(cluster, EvictingQueue.create((int)this.maxEventsPerCluster));
            eventQueue.addAll(events);
            this.store.put(cluster, eventQueue);
            events.forEach(event -> event.accept((EventVisitor)this.eventPublishingVisitor));
        }
        finally {
            this.wLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractWanEvent[] getEventsForCluster(String cluster) {
        this.rLock.lock();
        try {
            EvictingQueue events = (EvictingQueue)this.store.get(cluster);
            AbstractWanEvent[] abstractWanEventArray = events != null ? (AbstractWanEvent[])events.toArray(AbstractWanEvent[]::new) : EMPTY_WAN_EVENTS;
            return abstractWanEventArray;
        }
        finally {
            this.rLock.unlock();
        }
    }

    @Override
    public void close() {
        ExecutorServiceShutdownUtils.shutdownExecutorService((ExecutorService)this.executor);
    }

    @ConstructorProperties(value={"eventPublishingVisitor", "maxEventsPerCluster", "clock"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    WanEventStore(EventPublishingVisitor eventPublishingVisitor, int maxEventsPerCluster, Clock clock) {
        this.eventPublishingVisitor = eventPublishingVisitor;
        this.maxEventsPerCluster = maxEventsPerCluster;
        this.clock = clock;
    }
}

