/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.events;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.hazelcast.webmonitor.events.EventPublishingVisitor;
import com.hazelcast.webmonitor.events.EventVisitor;
import com.hazelcast.webmonitor.events.model.ConfigUpdateEvent;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class ConfigUpdateEventStore {
    private final EventPublishingVisitor eventPublishingVisitor;
    private final Cache<UUID, List<ConfigUpdateEvent>> eventsByConfigProcess = Caffeine.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).build();

    public synchronized void store(List<ConfigUpdateEvent> incomingEvents) {
        Map<UUID, List<ConfigUpdateEvent>> groupedIncomingEvents = incomingEvents.stream().collect(Collectors.groupingBy(ConfigUpdateEvent::getConfigUpdateProcessId));
        groupedIncomingEvents.forEach((processId, events) -> ((List)this.eventsByConfigProcess.get(processId, __ -> new ArrayList(events.size()))).addAll(events));
        incomingEvents.forEach(event -> event.accept((EventVisitor)this.eventPublishingVisitor));
    }

    public synchronized List<ConfigUpdateEvent> findEventsByUpdateProcessId(UUID configUpdateProcessId) {
        List knownEvents = (List)this.eventsByConfigProcess.getIfPresent((Object)configUpdateProcessId);
        return knownEvents == null ? Collections.emptyList() : knownEvents;
    }

    @ConstructorProperties(value={"eventPublishingVisitor"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ConfigUpdateEventStore(EventPublishingVisitor eventPublishingVisitor) {
        this.eventPublishingVisitor = eventPublishingVisitor;
    }
}

