/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.controller.internal;

import com.hazelcast.instance.BuildInfoProvider;
import com.hazelcast.webmonitor.controller.dto.client.BaseClientDTO;
import com.hazelcast.webmonitor.controller.dto.client.ClientDTO;
import com.hazelcast.webmonitor.controller.dto.client.ClientFilteringConfigDTO;
import com.hazelcast.webmonitor.controller.dto.client.ClientFilteringListPreviewDTO;
import com.hazelcast.webmonitor.controller.dto.client.ClientFilteringListWithEntriesDTO;
import com.hazelcast.webmonitor.controller.dto.client.ClientFilteringListWithSizeDTO;
import com.hazelcast.webmonitor.controller.dto.client.ClientWithConnectionInfoDTO;
import com.hazelcast.webmonitor.controller.dto.client.ClientWithNearCacheDTO;
import com.hazelcast.webmonitor.controller.dto.clustered.ClientFilteringSummaryDTO;
import com.hazelcast.webmonitor.controller.dto.clustered.ClientFilteringTestDeployDTO;
import com.hazelcast.webmonitor.controller.exception.NoClientApiException;
import com.hazelcast.webmonitor.controller.exception.ValidationFailedApiException;
import com.hazelcast.webmonitor.model.AllState;
import com.hazelcast.webmonitor.model.hz.req.state.ClientEndPointDTO;
import com.hazelcast.webmonitor.model.sql.client.ClientFilteringListType;
import com.hazelcast.webmonitor.model.sql.client.ClientFilteringListWithEntries;
import com.hazelcast.webmonitor.model.sql.client.ClientModel;
import com.hazelcast.webmonitor.networking.IPAddressUtil;
import com.hazelcast.webmonitor.service.CacheManager;
import com.hazelcast.webmonitor.service.ClusterClientFilteringDTO;
import com.hazelcast.webmonitor.service.ClusterHealthCheckService;
import com.hazelcast.webmonitor.service.ClusterManager;
import com.hazelcast.webmonitor.service.MapManager;
import com.hazelcast.webmonitor.service.StateManager;
import com.hazelcast.webmonitor.service.client.ClientService;
import com.hazelcast.webmonitor.service.client_filtering.ClientFilteringService;
import com.hazelcast.webmonitor.service.client_filtering.ClientFilteringUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.validation.Valid;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.security.access.annotation.Secured;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(path={"/api"})
public class ClientController {
    private final StateManager stateManager;
    private final ClientService clientService;
    private final ClientFilteringService clientFilteringService;
    private final CacheManager cacheManager;
    private final MapManager mapManager;
    private final ClusterManager clusterManager;
    private final ClusterHealthCheckService clusterHealthCheckService;

    @GetMapping(path={"/clusters/{cluster}/clientDetails"})
    public List<ClientDTO> getClientDetails(@PathVariable String cluster) {
        if (!this.clusterManager.isClusterConnected(cluster)) {
            return Collections.emptyList();
        }
        AllState allState = this.stateManager.getLatestState(cluster);
        if (allState == null) {
            return Collections.emptyList();
        }
        Map clients = allState.getClientsPerUuid();
        ArrayList<ClientDTO> result = new ArrayList<ClientDTO>(clients.size());
        for (Map.Entry entry : clients.entrySet()) {
            String uuid = (String)entry.getKey();
            ClientEndPointDTO client = (ClientEndPointDTO)entry.getValue();
            ClientDTO clientDTO = ClientController.prepareClientDTO((ClientEndPointDTO)client, (Set)allState.getMembersPerClientUuid(uuid));
            result.add(clientDTO);
        }
        return result;
    }

    @GetMapping(path={"/clusters/{cluster}/clients"})
    public List<BaseClientDTO> getClients(@PathVariable String cluster, @RequestParam(defaultValue="0") long time, @RequestParam(defaultValue="0") long interval) {
        return ClientController.toBaseClientDTO((List)this.clientService.findClients(cluster, time, interval));
    }

    private static List<BaseClientDTO> toBaseClientDTO(List<ClientModel> models) {
        return models.stream().map(model -> new BaseClientDTO(model.getName(), model.getUuid().toString())).collect(Collectors.toList());
    }

    @GetMapping(path={"/clusters/{cluster}/clients/{clientUuid}"})
    public ClientDTO getClientDetails(@PathVariable String cluster, @PathVariable String clientUuid) {
        AllState allState = this.stateManager.getLatestState(cluster);
        if (allState == null) {
            throw NoClientApiException.forUuid((String)clientUuid);
        }
        ClientEndPointDTO client = (ClientEndPointDTO)allState.getClientsPerUuid().get(clientUuid);
        if (client == null) {
            throw NoClientApiException.forUuid((String)clientUuid);
        }
        return ClientController.prepareClientDTO((ClientEndPointDTO)client, (Set)allState.getMembersPerClientUuid(clientUuid));
    }

    @GetMapping(path={"/clusters/{cluster}/clients/{clientUuid}/nearCache/maps"})
    public SortedSet<String> getNearCachedMaps(@PathVariable String cluster, @PathVariable String clientUuid) {
        return this.mapManager.getMapsWithClientNearCache(cluster, clientUuid);
    }

    @GetMapping(path={"/clusters/{cluster}/clients/{clientUuid}/nearCache/caches"})
    public SortedSet<String> getNearCachedCaches(@PathVariable String cluster, @PathVariable String clientUuid) {
        return this.cacheManager.getCachesWithClientNearCache(cluster, clientUuid);
    }

    @GetMapping(path={"/clusters/{cluster}/maps/{map}/nearCache/clients"})
    public List<ClientWithNearCacheDTO> getClientsWithNearCachedMap(@PathVariable String cluster, @PathVariable String map) {
        return this.mapManager.getClientsWithNearCache(cluster, map);
    }

    @GetMapping(path={"/clusters/{cluster}/caches/{cache}/nearCache/clients"})
    public List<ClientWithNearCacheDTO> getClientsWithNearCachedCache(@PathVariable String cluster, @PathVariable String cache) {
        return this.cacheManager.getClientsWithNearCache(cluster, cache);
    }

    @GetMapping(path={"/clusters/{cluster}/clientFiltering"})
    @Secured(value={"ROLE_ADMIN", "ROLE_USER", "ROLE_READONLY_USER", "ROLE_CLOUD_USER"})
    public ClientFilteringSummaryDTO getSummary(@PathVariable String cluster) {
        ClusterClientFilteringDTO fullConfig = this.clientFilteringService.getFullClientFilteringConfigForCluster(cluster);
        int connectedClients = Optional.ofNullable(this.clusterHealthCheckService.check(cluster).getNumberOfConnectedClients()).orElse(0);
        return ClientFilteringSummaryDTO.builder().status(fullConfig.getStatus()).type(fullConfig.getType()).numberOfConnectedClients(connectedClients).activeRules(ClientFilteringUtil.groupByTypeAndSortEntries((List)fullConfig.getActiveEntries())).etag(fullConfig.getEtag()).build();
    }

    @PostMapping(path={"/clusters/{cluster}/clientFiltering/deploy"})
    @Secured(value={"ROLE_ADMIN", "ROLE_USER", "ROLE_CLOUD_USER"})
    public void deploy(@PathVariable(value="cluster") String cluster, @Valid @RequestBody ClientFilteringConfigDTO input, BindingResult bindingResult) {
        ValidationFailedApiException.processValidationResult((BindingResult)bindingResult);
        this.clusterManager.verifyClusterConnected(cluster);
        this.clientFilteringService.deploy(cluster, input.getStatus(), input.getType());
    }

    @GetMapping(path={"/clusters/{cluster}/clientFiltering/lists"})
    @Secured(value={"ROLE_ADMIN", "ROLE_USER", "ROLE_READONLY_USER", "ROLE_CLOUD_USER"})
    public List<ClientFilteringListWithSizeDTO> getClientFilteringLists(@PathVariable(value="cluster") String cluster) {
        this.clusterManager.verifyClusterConnected(cluster);
        return this.clientFilteringService.getAll(cluster).stream().map(ClientFilteringListWithSizeDTO::fromModel).collect(Collectors.toList());
    }

    @GetMapping(path={"/clusters/{cluster}/clientFiltering/lists/{listId}"})
    @Secured(value={"ROLE_ADMIN", "ROLE_USER", "ROLE_READONLY_USER", "ROLE_CLOUD_USER"})
    public ClientFilteringListWithEntriesDTO getClientFilteringList(@PathVariable(value="cluster") String cluster, @PathVariable(value="listId") Long listId) {
        this.clusterManager.verifyClusterConnected(cluster);
        ClientFilteringListWithEntries listWithEntries = this.clientFilteringService.get(listId);
        return ClientFilteringListWithEntriesDTO.fromModel((ClientFilteringListWithEntries)listWithEntries);
    }

    @PostMapping(path={"/clusters/{cluster}/clientFiltering/lists"})
    @Secured(value={"ROLE_ADMIN", "ROLE_USER", "ROLE_CLOUD_USER"})
    public ClientFilteringListWithEntriesDTO createClientFilteringList(@PathVariable(value="cluster") String cluster, @Valid @RequestBody ClientFilteringListWithEntriesDTO input, BindingResult bindingResult) {
        ValidationFailedApiException.processValidationResult((BindingResult)bindingResult);
        this.clusterManager.verifyClusterConnected(cluster);
        ClientFilteringListWithEntries listWithEntries = this.clientFilteringService.create(cluster, input.toModel());
        return ClientFilteringListWithEntriesDTO.fromModel((ClientFilteringListWithEntries)listWithEntries);
    }

    @PostMapping(path={"/clusters/{cluster}/clientFiltering/lists/{listId}"})
    @Secured(value={"ROLE_ADMIN", "ROLE_USER", "ROLE_CLOUD_USER"})
    public void updateClientFilteringList(@PathVariable(value="cluster") String cluster, @PathVariable(value="listId") Long listId, @Valid @RequestBody ClientFilteringListWithEntriesDTO input, BindingResult bindingResult) {
        ValidationFailedApiException.processValidationResult((BindingResult)bindingResult);
        this.clusterManager.verifyClusterConnected(cluster);
        input.setId(listId);
        this.clientFilteringService.update(cluster, input.toModel());
    }

    @DeleteMapping(path={"/clusters/{cluster}/clientFiltering/lists/{listId}"})
    @Secured(value={"ROLE_ADMIN", "ROLE_USER", "ROLE_CLOUD_USER"})
    public void deleteClientFilteringList(@PathVariable(value="cluster") String cluster, @PathVariable(value="listId") Long listId) {
        this.clusterManager.verifyClusterConnected(cluster);
        this.clientFilteringService.delete(cluster, listId);
    }

    @GetMapping(path={"/clusters/{cluster}/clientFiltering/testDeploy"})
    @Secured(value={"ROLE_ADMIN", "ROLE_USER", "ROLE_CLOUD_USER"})
    public ClientFilteringTestDeployDTO clientFilteringPreview(@PathVariable String cluster, @RequestParam ClientFilteringListType type) {
        return this.clientFilteringService.testDeploy(cluster, type);
    }

    @PostMapping(path={"/clusters/{cluster}/clientFiltering/preview"})
    @Secured(value={"ROLE_ADMIN", "ROLE_USER", "ROLE_CLOUD_USER"})
    public ClientFilteringTestDeployDTO clientFilteringPreview(@PathVariable String cluster, @Valid @RequestBody ClientFilteringListPreviewDTO input) {
        return this.clientFilteringService.preview(cluster, input);
    }

    private static ClientDTO prepareClientDTO(ClientEndPointDTO client, Set<String> connectedMembers) {
        ClientDTO.ClientDTOBuilder builder = ((ClientDTO.ClientDTOBuilder)((ClientDTO.ClientDTOBuilder)ClientDTO.builder().name(client.getName())).type(client.getClientType()).version(client.getClientVersion()).statsEnabled(client.getStatsEnabled().booleanValue()).cpDirectToLeader(client.getCpDirectToLeader()).lastConnectionToCluster(client.getClusterConnectionTimestamp()).uuid(client.getUuid())).enterprise(client.getEnterprise()).address(IPAddressUtil.trimPort((String)client.getAddress())).ipAddress(client.getIpAddress()).canonicalHostName(client.getCanonicalHostName()).connectedMembers(connectedMembers).routingMode(ClientWithConnectionInfoDTO.inferRoutingMode((ClientEndPointDTO)client, connectedMembers));
        if (client.getLabels() != null) {
            builder.labels(new TreeSet(client.getLabels()));
        }
        if (client.getClientVersion() == null && client.getName().startsWith("MC-Client-")) {
            builder.version(BuildInfoProvider.getBuildInfo().getVersion());
        }
        return builder.build();
    }

    @ConstructorProperties(value={"stateManager", "clientService", "clientFilteringService", "cacheManager", "mapManager", "clusterManager", "clusterHealthCheckService"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ClientController(StateManager stateManager, ClientService clientService, ClientFilteringService clientFilteringService, CacheManager cacheManager, MapManager mapManager, ClusterManager clusterManager, ClusterHealthCheckService clusterHealthCheckService) {
        this.stateManager = stateManager;
        this.clientService = clientService;
        this.clientFilteringService = clientFilteringService;
        this.cacheManager = cacheManager;
        this.mapManager = mapManager;
        this.clusterManager = clusterManager;
        this.clusterHealthCheckService = clusterHealthCheckService;
    }
}

