/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.controller.internal;

import com.hazelcast.wan.WanPublisherState;
import com.hazelcast.wan.impl.AddWanConfigResult;
import com.hazelcast.webmonitor.auditlog.AuditLogService;
import com.hazelcast.webmonitor.controller.dto.AddWanReplicationDTO;
import com.hazelcast.webmonitor.controller.dto.wan.MapWithWanReplicationDTO;
import com.hazelcast.webmonitor.controller.dto.wan.WanConsistencyCheckResultDTO;
import com.hazelcast.webmonitor.controller.dto.wan.WanPublisherStatsDTO;
import com.hazelcast.webmonitor.controller.dto.wan.WanReplicationDTO;
import com.hazelcast.webmonitor.controller.dto.wan.WanSyncResultDTO;
import com.hazelcast.webmonitor.controller.exception.ValidationFailedApiException;
import com.hazelcast.webmonitor.controller.internal.BaseInternalController;
import com.hazelcast.webmonitor.model.AllState;
import com.hazelcast.webmonitor.service.AddWanConfigResultDTO;
import com.hazelcast.webmonitor.service.StateManager;
import com.hazelcast.webmonitor.service.WanReplicationManager;
import com.hazelcast.webmonitor.service.wan.WanReplicationConfigService;
import com.hazelcast.webmonitor.service.wan.WanReplicationStatsService;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;

public abstract class BaseWANController
extends BaseInternalController {
    public static final String CLUSTER = "cluster";
    public static final String WAN_REPLICATION = "wanReplication";
    public static final String PUBLISHER = "publisher";
    public static final String MAP = "map";
    public static final String ALL_MAPS = "allMaps";
    public static final String STATE = "state";
    public static final String MEMBER = "member";
    public static final String ALL_MEMBERS = "allMembers";
    protected final WanReplicationManager wanReplicationManager;
    protected final WanReplicationStatsService wanStatsService;
    protected final WanReplicationConfigService wanReplicationConfigService;

    protected BaseWANController(StateManager stateManager, WanReplicationManager wanReplicationManager, WanReplicationStatsService wanStatsService, WanReplicationConfigService wanReplicationConfigService, AuditLogService auditService) {
        super(stateManager, auditService);
        this.wanReplicationManager = wanReplicationManager;
        this.wanStatsService = wanStatsService;
        this.wanReplicationConfigService = wanReplicationConfigService;
    }

    protected List<WanReplicationDTO> getWanReplicationsInternal(String cluster, String replication, String publisher) {
        if (replication == null ^ publisher == null) {
            throw new ValidationFailedApiException("Replication and publisher must be specified together.");
        }
        AllState state = this.stateManager.getLatestState(cluster);
        if (state == null) {
            return Collections.emptyList();
        }
        return this.wanStatsService.getWanReplications(state, cluster, replication, publisher);
    }

    protected WanReplicationDTO getWanReplicationInternal(String cluster, String replication) {
        AllState state = this.stateManager.getLatestState(cluster);
        if (state == null) {
            return null;
        }
        return this.wanStatsService.getWanReplication(state, cluster, replication);
    }

    protected WanPublisherStatsDTO getPublisherInternal(String cluster, String replication, String publisher) {
        AllState state = this.stateManager.getLatestState(cluster);
        if (state == null) {
            return null;
        }
        return this.wanStatsService.getWanPublisherStats(state, cluster, replication, publisher);
    }

    protected List<MapWithWanReplicationDTO> getMapsInternal(String cluster, String replication) {
        AllState state = this.stateManager.getLatestState(cluster);
        if (state == null) {
            return Collections.emptyList();
        }
        return this.wanReplicationConfigService.getWanReplicatedMaps(state, cluster, replication);
    }

    protected AddWanConfigResultDTO addWanReplicationInternal(String cluster, AddWanReplicationDTO addWanReplicationDTO) {
        return (AddWanConfigResultDTO)this.executeOperation(() -> {
            AddWanConfigResult result = this.wanReplicationManager.addConfig(cluster, addWanReplicationDTO);
            return new AddWanConfigResultDTO(result.getAddedPublisherIds(), result.getIgnoredPublisherIds());
        }, this.operationLogBuilder("MC-7001 [WAN]", "Add WAN Configuration").parameter(CLUSTER, (Object)cluster).parameter(WAN_REPLICATION, (Object)addWanReplicationDTO.getName()));
    }

    protected WanConsistencyCheckResultDTO startWanConsistencyCheckInternal(String cluster, String wanReplication, String publisher, String syncMap) {
        UUID id = (UUID)this.executeOperation(() -> this.wanReplicationManager.checkConsistency(cluster, wanReplication, publisher, syncMap), this.operationLogBuilder("MC-7002 [WAN]", "Run WAN Consistency Check").parameter(CLUSTER, (Object)cluster).parameter(WAN_REPLICATION, (Object)wanReplication).parameter(PUBLISHER, (Object)publisher).parameter(MAP, (Object)syncMap));
        return new WanConsistencyCheckResultDTO(id);
    }

    protected WanSyncResultDTO startWanMapSyncInternal(String cluster, String wanReplication, String publisher, String syncMap) {
        Supplier<UUID> operation = syncMap != null ? () -> this.wanReplicationManager.syncMap(cluster, wanReplication, publisher, syncMap) : () -> this.wanReplicationManager.syncAllMaps(cluster, wanReplication, publisher);
        UUID id = (UUID)this.executeOperation(operation, this.operationLogBuilder("MC-7003 [WAN]", "Run WAN Sync Map").parameter(CLUSTER, (Object)cluster).parameter(WAN_REPLICATION, (Object)wanReplication).parameter(PUBLISHER, (Object)publisher).parameter(MAP, (Object)syncMap).parameter(ALL_MAPS, (Object)(syncMap == null ? 1 : 0)));
        return new WanSyncResultDTO(id);
    }

    protected void changeWanStateInternal(String cluster, String wanReplication, String publisher, WanPublisherState state, String member) {
        Runnable operation = member == null ? () -> this.wanReplicationManager.changeState(cluster, wanReplication, publisher, state) : () -> this.wanReplicationManager.changeState(cluster, wanReplication, publisher, member, state);
        this.executeOperation(operation, this.operationLogBuilder("MC-7004 [WAN]", "Change WAN Publisher State").parameter(CLUSTER, (Object)cluster).parameter(WAN_REPLICATION, (Object)wanReplication).parameter(PUBLISHER, (Object)publisher).parameter(STATE, (Object)state).parameter(MEMBER, (Object)member).parameter(ALL_MEMBERS, (Object)(member == null ? 1 : 0)));
    }

    protected void clearQueuesInternal(String cluster, String wanReplication, String publisher, String member) {
        Runnable operation = member == null ? () -> this.wanReplicationManager.clearQueues(cluster, wanReplication, publisher) : () -> this.wanReplicationManager.clearQueues(cluster, wanReplication, publisher, member);
        this.executeOperation(operation, this.operationLogBuilder("MC-7005 [WAN]", "Clear WAN Queues").parameter(CLUSTER, (Object)cluster).parameter(WAN_REPLICATION, (Object)wanReplication).parameter(PUBLISHER, (Object)publisher));
    }
}

