/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.controller.internal;

import com.hazelcast.webmonitor.auditlog.AuditLogService;
import com.hazelcast.webmonitor.auditlog.impl.AuditableEvent;
import com.hazelcast.webmonitor.controller.exception.NoClusterApiException;
import com.hazelcast.webmonitor.model.AllState;
import com.hazelcast.webmonitor.service.StateManager;
import com.hazelcast.webmonitor.utils.SecurityContextUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.function.Supplier;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseInternalController {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final StateManager stateManager;
    protected final AuditLogService auditService;

    protected AllState getState(String cluster) {
        AllState state = this.stateManager.getLatestState(cluster);
        if (state == null) {
            throw new NoClusterApiException(cluster);
        }
        return state;
    }

    protected void executeOperation(Runnable runnable, AuditableEvent.AuditableEventBuilder operationLogBuilder) {
        this.executeOperation(() -> {
            runnable.run();
            return null;
        }, operationLogBuilder);
    }

    protected <T> T executeOperation(Supplier<T> supplier, AuditableEvent.AuditableEventBuilder operationLogBuilder) {
        try {
            T result = supplier.get();
            this.auditService.log(operationLogBuilder.parameter("result", (Object)"success").build());
            return result;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            this.auditService.log(operationLogBuilder.parameter("result", (Object)"failure").build());
            throw e;
        }
    }

    protected AuditableEvent.AuditableEventBuilder operationLogBuilder(String eventId, String operation) {
        return this.logBuilder(eventId, "Operation was executed by user").parameter("operationName", (Object)operation);
    }

    protected AuditableEvent.AuditableEventBuilder configLogBuilder(String eventId, String configChange) {
        return this.logBuilder(eventId, "Configuration change was triggered by user").parameter("configChange", (Object)configChange);
    }

    protected AuditableEvent.AuditableEventBuilder logBuilder(String eventId, String message) {
        return AuditableEvent.builder().typeId(eventId).message(message).parameter("username", (Object)SecurityContextUtil.getUsername());
    }

    @ConstructorProperties(value={"stateManager", "auditService"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public BaseInternalController(StateManager stateManager, AuditLogService auditService) {
        this.stateManager = stateManager;
        this.auditService = auditService;
    }
}

