/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.controller.external;

import com.hazelcast.license.domain.Feature;
import com.hazelcast.webmonitor.controller.dto.diagnosticconfig.DiagnosticsConfigResponseDTO;
import com.hazelcast.webmonitor.controller.dto.diagnosticconfig.UpdateDiagnosticsConfigRequestDTO;
import com.hazelcast.webmonitor.service.Licensed;
import com.hazelcast.webmonitor.service.diagnosticsconfig.DiagnosticsConfigVersionAwareService;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/rest/clusters/{cluster}/diagnostics/config"})
@ConditionalOnProperty(name={"hazelcast.mc.rest.enabled"}, havingValue="true")
public class DiagnosticsConfigRestController {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DiagnosticsConfigRestController.class);
    private final DiagnosticsConfigVersionAwareService diagnosticsConfigService;

    @GetMapping
    @Licensed(value={Feature.CLUSTERED_REST})
    public DiagnosticsConfigResponseDTO getDiagnosticsConfig(@PathVariable String cluster) {
        log.info("Fetching diagnostics config for cluster: {}", (Object)cluster);
        return this.diagnosticsConfigService.getDiagnosticsConfig(cluster);
    }

    @PostMapping
    @Secured(value={"ROLE_ADMIN"})
    @Licensed(value={Feature.CLUSTERED_REST})
    public void updateDiagnosticsConfig(@PathVariable String cluster, @RequestBody UpdateDiagnosticsConfigRequestDTO updateRequest) {
        log.info("Updating diagnostics config for cluster: {}", (Object)cluster);
        this.diagnosticsConfigService.setDiagnosticsConfig(cluster, updateRequest);
    }

    @ConstructorProperties(value={"diagnosticsConfigService"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public DiagnosticsConfigRestController(DiagnosticsConfigVersionAwareService diagnosticsConfigService) {
        this.diagnosticsConfigService = diagnosticsConfigService;
    }
}

