/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.controller.external;

import com.hazelcast.webmonitor.controller.dto.ApiErrorDTO;
import com.hazelcast.webmonitor.controller.dto.clusterconnectionconfig.ClusterConnectionConfigDTO;
import com.hazelcast.webmonitor.controller.exception.ValidationFailedApiException;
import com.hazelcast.webmonitor.controller.external.ClusterConnectionConfigControllerCondition;
import com.hazelcast.webmonitor.model.sql.ClusterModel;
import com.hazelcast.webmonitor.service.ClusterManager;
import com.hazelcast.webmonitor.service.exception.InvalidClusterConnectionConfigException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.validation.Valid;
import java.beans.ConstructorProperties;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.context.annotation.Conditional;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/rest/mc/clusterConnectionConfigs"})
@Secured(value={"ROLE_ADMIN"})
@Conditional(value={ClusterConnectionConfigControllerCondition.class})
public class ClusterConnectionConfigController {
    private final ClusterManager clusterManager;

    @GetMapping
    public List<ClusterConnectionConfigDTO> getClusterConfigs() {
        return this.clusterManager.getAllClusterConfigs().stream().map(ClusterConnectionConfigDTO::fromModel).collect(Collectors.toList());
    }

    @GetMapping(value={"/{clusterName}"})
    public ClusterConnectionConfigDTO getClusterConfig(@PathVariable String clusterName) {
        return ClusterConnectionConfigDTO.fromModel((ClusterModel)this.clusterManager.getCluster(clusterName));
    }

    @PostMapping
    public ResponseEntity<?> createOrUpdateConfig(@Valid @RequestBody ClusterConnectionConfigDTO config, BindingResult bindingResult) {
        boolean updated;
        ValidationFailedApiException.processValidationResult((BindingResult)bindingResult);
        ClusterModel model = config.toModel();
        try {
            updated = this.clusterManager.createOrUpdateCluster(model);
        }
        catch (InvalidClusterConnectionConfigException e) {
            return ResponseEntity.badRequest().body((Object)new ApiErrorDTO("CLUSTER_NAME_MISMATCH", e.getMessage()));
        }
        if (updated) {
            return ResponseEntity.ok().build();
        }
        String encodedClusterName = URLEncoder.encode(config.getClusterName(), StandardCharsets.UTF_8);
        return ResponseEntity.created((URI)URI.create("/rest/mc/clusterConnectionConfigs/" + encodedClusterName)).build();
    }

    @DeleteMapping(value={"/{clusterName}"})
    public void deleteClusterConfig(@PathVariable String clusterName) {
        this.clusterManager.getCluster(clusterName);
        this.clusterManager.remove(clusterName);
    }

    @ConstructorProperties(value={"clusterManager"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ClusterConnectionConfigController(ClusterManager clusterManager) {
        this.clusterManager = clusterManager;
    }
}

