/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.console;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.hazelcast.webmonitor.console.ConsoleIOProcessor;
import com.hazelcast.webmonitor.utils.ExecutorServiceShutdownUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.simp.SimpMessagingTemplate;

public class ConsoleIOProcessor
implements AutoCloseable {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConsoleIOProcessor.class);
    private static final Long READER_PERIOD = 10L;
    private static final Integer BUFFER_SIZE = 1024;
    private final SimpMessagingTemplate messagingTemplate;
    private final String username;
    private final String uuid;
    private final BufferedReader reader;
    private final ScheduledExecutorService executor;
    private ScheduledFuture<?> future;

    public ConsoleIOProcessor(SimpMessagingTemplate messagingTemplate, InputStream inputStream, String username, String uuid) {
        this.messagingTemplate = messagingTemplate;
        this.username = username;
        this.uuid = uuid;
        this.reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        this.executor = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("ConsoleIOProcessor-" + uuid).build());
    }

    void schedule() {
        this.future = this.executor.schedule((Runnable)new Task(this), (long)READER_PERIOD, TimeUnit.MILLISECONDS);
    }

    @Override
    public void close() {
        this.future.cancel(true);
        this.future = null;
        ExecutorServiceShutdownUtils.shutdownExecutorService((ExecutorService)this.executor);
    }

    boolean isRunning() {
        return this.future != null;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SimpMessagingTemplate getMessagingTemplate() {
        return this.messagingTemplate;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getUsername() {
        return this.username;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getUuid() {
        return this.uuid;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public BufferedReader getReader() {
        return this.reader;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ScheduledExecutorService getExecutor() {
        return this.executor;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ScheduledFuture<?> getFuture() {
        return this.future;
    }
}

