/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.config;

import com.hazelcast.webmonitor.config.WebSocketMessageBrokerConfig;
import com.hazelcast.webmonitor.config.properties.CorsConfigurationProperties;
import com.hazelcast.webmonitor.config.properties.WebSocketConfigurationProperties;
import com.hazelcast.webmonitor.notify.Notifier;
import com.hazelcast.webmonitor.websocket.NotifyingHandshakeHandler;
import com.hazelcast.webmonitor.websocket.StompErrorHandler;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Lazy;
import org.springframework.http.MediaType;
import org.springframework.messaging.Message;
import org.springframework.messaging.converter.MappingJackson2MessageConverter;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.simp.SimpMessageType;
import org.springframework.messaging.simp.config.MessageBrokerRegistry;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.config.annotation.web.socket.EnableWebSocketSecurity;
import org.springframework.security.messaging.access.intercept.MessageMatcherDelegatingAuthorizationManager;
import org.springframework.util.MimeType;
import org.springframework.util.StringUtils;
import org.springframework.web.socket.config.annotation.StompEndpointRegistry;
import org.springframework.web.socket.config.annotation.WebSocketMessageBrokerConfigurer;
import org.springframework.web.socket.config.annotation.WebSocketTransportRegistration;
import org.springframework.web.socket.messaging.StompSubProtocolErrorHandler;
import org.springframework.web.socket.server.HandshakeHandler;

@Configuration
@EnableScheduling
@EnableWebSocketSecurity
@Import(value={WebSocketMessageBrokerConfig.class})
public class WebSocketConfig
implements WebSocketMessageBrokerConfigurer {
    private static final String[] ALLOWED_ROLES = new String[]{"ADMIN", "USER", "CLOUD_USER"};
    public static final String TOPIC_SQL_RESULTS = "/topic/sql-results/";
    public static final String TOPIC_CONSOLE_RESULTS = "/topic/console/";
    protected final Notifier notifier;
    private TaskScheduler messageBrokerTaskScheduler;
    private WebSocketConfigurationProperties webSocketConfigurationProperties;
    private CorsConfigurationProperties corsConfigurationProperties;

    @Autowired
    public void setMessageBrokerTaskScheduler(@Lazy TaskScheduler taskScheduler, WebSocketConfigurationProperties webSocketConfigurationProperties, CorsConfigurationProperties corsConfigurationProperties) {
        this.messageBrokerTaskScheduler = taskScheduler;
        this.webSocketConfigurationProperties = webSocketConfigurationProperties;
        this.corsConfigurationProperties = corsConfigurationProperties;
    }

    @Bean
    AuthorizationManager<Message<?>> messageSecurity(MessageMatcherDelegatingAuthorizationManager.Builder messages) {
        return messages.simpTypeMatchers(new SimpMessageType[]{SimpMessageType.CONNECT, SimpMessageType.DISCONNECT, SimpMessageType.UNSUBSCRIBE}).permitAll().simpMessageDestMatchers(new String[]{"/user/**"}).denyAll().simpMessageDestMatchers(new String[]{"/topic/**"}).denyAll().simpDestMatchers(new String[]{"/topic/sql-results/**"}).hasAnyRole(ALLOWED_ROLES).simpDestMatchers(new String[]{"/topic/console/**"}).hasAnyRole(ALLOWED_ROLES).anyMessage().authenticated().build();
    }

    public void registerStompEndpoints(StompEndpointRegistry registry) {
        registry.setErrorHandler((StompSubProtocolErrorHandler)new StompErrorHandler());
        registry.addEndpoint(new String[]{"/ws"}).setAllowedOriginPatterns(StringUtils.toStringArray((Collection)this.corsConfigurationProperties.getAllowedOriginPatterns())).setHandshakeHandler((HandshakeHandler)new NotifyingHandshakeHandler(this.notifier));
        registry.setOrder(Integer.MIN_VALUE);
    }

    public void configureMessageBroker(MessageBrokerRegistry registry) {
        registry.enableSimpleBroker(new String[]{"/topic"}).setTaskScheduler(this.messageBrokerTaskScheduler);
        registry.setApplicationDestinationPrefixes(new String[]{"/app"});
        registry.setPreservePublishOrder(true);
    }

    public boolean configureMessageConverters(List<MessageConverter> messageConverters) {
        messageConverters.add((MessageConverter)new MappingJackson2MessageConverter(new MimeType[]{MediaType.APPLICATION_JSON}));
        return false;
    }

    public void configureWebSocketTransport(WebSocketTransportRegistration registration) {
        registration.setSendBufferSizeLimit((int)this.webSocketConfigurationProperties.getBufferSize().toBytes());
    }

    @ConstructorProperties(value={"notifier"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public WebSocketConfig(Notifier notifier) {
        this.notifier = notifier;
    }
}

