/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.config;

import com.hazelcast.webmonitor.config.properties.MCConfigurationProperties;
import com.hazelcast.webmonitor.service.HomeDirectoryProvider;
import com.zaxxer.hikari.HikariDataSource;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.sql.Connection;
import java.util.function.UnaryOperator;
import javax.sql.DataSource;
import liquibase.Contexts;
import liquibase.Liquibase;
import liquibase.Scope;
import liquibase.UpdateSummaryEnum;
import liquibase.UpdateSummaryOutputEnum;
import liquibase.database.DatabaseConnection;
import liquibase.database.jvm.JdbcConnection;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import liquibase.ui.LoggerUIService;
import lombok.Generated;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.h2.H2DatabasePlugin;
import org.jdbi.v3.core.mapper.CaseStrategy;
import org.jdbi.v3.core.mapper.reflect.ReflectionMappers;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/*
 * Exception performing whole class analysis ignored.
 */
@Configuration
public class SqlDbConfig {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SqlDbConfig.class);
    private static final String DEFAULT_DB_USERNAME = "mc";
    private static final String DB_FILE = "mc";
    private static final String DB_DIR = "metadata";
    private final boolean skipLocking;

    public SqlDbConfig(boolean skipLocking) {
        this.skipLocking = skipLocking;
    }

    @Autowired
    public SqlDbConfig(MCConfigurationProperties properties) {
        this(properties.isSkipLocking());
    }

    @Bean
    public Jdbi jdbi(DataSource ds) {
        SqlDbConfig.migrateDB((DataSource)ds, (String[])new String[]{"!test"});
        return ((Jdbi)Jdbi.create((DataSource)ds).configure(ReflectionMappers.class, rm -> rm.setCaseChange((UnaryOperator)CaseStrategy.NOP))).installPlugin((JdbiPlugin)new H2DatabasePlugin());
    }

    @Bean
    public HikariDataSource dataSource(HomeDirectoryProvider homeDirectoryProvider) {
        HikariDataSource ds = new HikariDataSource();
        ds.setJdbcUrl(this.getJdbcUrl(homeDirectoryProvider));
        ds.setDriverClassName("org.h2.Driver");
        ds.setUsername("mc");
        ds.setPassword(null);
        ds.setMinimumIdle(1);
        ds.setMaximumPoolSize(10);
        return ds;
    }

    public static void migrateDB(DataSource ds, String ... contexts) {
        try (Connection connection = ds.getConnection();
             Liquibase lb = new Liquibase("/db/changelog/db.changelog-master.xml", (ResourceAccessor)new ClassLoaderResourceAccessor(), (DatabaseConnection)new JdbcConnection(connection));){
            Scope.child((String)Scope.Attr.ui.name(), (Object)new LoggerUIService(), () -> {
                lb.setShowSummary(UpdateSummaryEnum.VERBOSE);
                lb.setShowSummaryOutput(UpdateSummaryOutputEnum.LOG);
                lb.update(new Contexts(contexts));
            });
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't migrate MC DB", e);
        }
    }

    private String getJdbcUrl(HomeDirectoryProvider homeDirectoryProvider) {
        String dbPath = homeDirectoryProvider.get().resolve("metadata").resolve("mc").toString().replace("\\", "/");
        String url = "jdbc:h2:file:" + dbPath + ";USER=mc";
        if (this.skipLocking) {
            url = url + ";FILE_LOCK=NO";
        }
        return url;
    }
}

