/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.config;

import com.hazelcast.webmonitor.config.properties.JMXConfigurationProperties;
import com.hazelcast.webmonitor.service.ClientNearCacheStatsManager;
import com.hazelcast.webmonitor.service.ClusterManager;
import com.hazelcast.webmonitor.service.ClusteredJetStatsProvider;
import com.hazelcast.webmonitor.service.ClusteredStatsService;
import com.hazelcast.webmonitor.service.EnterpriseServiceProvider;
import com.hazelcast.webmonitor.service.LicenseManager;
import com.hazelcast.webmonitor.service.jmx.impl.JMXService;
import com.hazelcast.webmonitor.service.jmx.impl.JMXServiceImpl;
import javax.management.MBeanServer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jmx.support.MBeanServerFactoryBean;

@Configuration
@ConditionalOnProperty(value={"hazelcast.mc.jmx.enabled"}, havingValue="true")
public class JMXConfiguration {
    @Bean
    public MBeanServer mbeanServer() {
        MBeanServerFactoryBean factory = new MBeanServerFactoryBean();
        factory.setLocateExistingServerIfPossible(true);
        factory.afterPropertiesSet();
        return factory.getObject();
    }

    @Bean
    public JMXService jmxService(EnterpriseServiceProvider enterpriseServiceProvider, ClusteredStatsService clusteredStatsService, ClientNearCacheStatsManager clientNearCacheStatsManager, LicenseManager licenseManager, ClusterManager clusterManager, ClusteredJetStatsProvider clusteredJetStatsProvider, JMXConfigurationProperties jmxProperties, MBeanServer mBeanServer) {
        return new JMXServiceImpl(enterpriseServiceProvider, clusteredStatsService, clientNearCacheStatsManager, licenseManager, clusterManager, clusteredJetStatsProvider, jmxProperties, mBeanServer);
    }
}

