/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.config;

import com.hazelcast.webmonitor.config.properties.JMXConfigurationProperties;
import com.hazelcast.webmonitor.config.properties.MCConfigurationProperties;
import com.hazelcast.webmonitor.service.ClusterManager;
import com.hazelcast.webmonitor.service.ClusteredJetStatsAggregator;
import com.hazelcast.webmonitor.service.ClusteredJetStatsProvider;
import com.hazelcast.webmonitor.service.jet.JetService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnThreading;
import org.springframework.boot.autoconfigure.thread.Threading;
import org.springframework.boot.task.SimpleAsyncTaskExecutorBuilder;
import org.springframework.boot.task.ThreadPoolTaskExecutorBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.context.event.ApplicationEventMulticaster;
import org.springframework.context.event.SimpleApplicationEventMulticaster;
import org.springframework.core.task.TaskExecutor;

@Configuration
@EnableAspectJAutoProxy
public class AppConfig {
    private static final Logger EVENT_LOGGER = LoggerFactory.getLogger((String)"EventMulticaster");
    public static final String INTERNAL_MC_OBJECTS_PREFIX = "__mc.";

    @Bean(value={"applicationTaskExecutor", "taskExecutor"})
    @ConditionalOnThreading(value=Threading.PLATFORM)
    public TaskExecutor threadPoolTaskExecutor(ThreadPoolTaskExecutorBuilder taskExecutorBuilder) {
        return taskExecutorBuilder.build();
    }

    @Bean(value={"applicationTaskExecutor", "taskExecutor"})
    @ConditionalOnThreading(value=Threading.VIRTUAL)
    public TaskExecutor simpleAsyncTaskExecutor(SimpleAsyncTaskExecutorBuilder taskExecutorBuilder) {
        return taskExecutorBuilder.build();
    }

    @Bean(name={"applicationEventMulticaster"})
    public ApplicationEventMulticaster applicationEventMulticaster(BeanFactory beanFactory) {
        SimpleApplicationEventMulticaster eventMulticaster = new SimpleApplicationEventMulticaster(beanFactory);
        eventMulticaster.setErrorHandler(t -> EVENT_LOGGER.warn("An error occurred during event handling", t));
        return eventMulticaster;
    }

    @Bean
    public ClusteredJetStatsProvider clusteredJetStatsAggregator(JetService jetService, ClusterManager clusterManager, MCConfigurationProperties mcProperties, JMXConfigurationProperties jmxProperties) {
        if (jmxProperties.isEnabled() || mcProperties.getRest().isEnabled()) {
            return new ClusteredJetStatsAggregator(jetService, clusterManager);
        }
        return ClusteredJetStatsProvider.NOOP;
    }
}

