/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.cli;

import com.hazelcast.webmonitor.cli.BaseCliTask;
import com.hazelcast.webmonitor.cli.CliException;
import com.hazelcast.webmonitor.console.ConsoleManager;
import com.hazelcast.webmonitor.model.sql.ClusterModel;
import com.hazelcast.webmonitor.repositories.sql.ClientFilteringDAO;
import com.hazelcast.webmonitor.repositories.sql.ClusterDAO;
import com.hazelcast.webmonitor.repositories.sql.ClusterRepository;
import com.hazelcast.webmonitor.sql.JdbiHistories;
import com.hazelcast.webmonitor.utils.StringUtil;
import java.io.PrintWriter;
import java.nio.file.Path;
import org.jdbi.v3.core.Jdbi;
import org.springframework.core.env.ConfigurableEnvironment;
import picocli.CommandLine;

@CommandLine.Command(description={"Remove Cluster Connection Config. *Important notice* Make sure that Management Center web application is stopped (offline) before starting this task.%n"}, mixinStandardHelpOptions=true, sortOptions=false)
public class RemoveClusterConfigTask
extends BaseCliTask {
    @CommandLine.Option(names={"-cn", "--cluster-name"}, paramLabel="<name>", description={"Cluster name."})
    private String clusterName;

    RemoveClusterConfigTask(PrintWriter out, ConfigurableEnvironment environment) {
        super(out, environment);
    }

    public void execute() {
        if (StringUtil.isNullOrEmptyAfterTrim((String)this.clusterName)) {
            throw new CliException("Please provide cluster name to remove via -cn= or --cluster-name= option");
        }
        Jdbi jdbi = this.initJdbi();
        ClusterDAO clusterDAO = new ClusterDAO(jdbi);
        ClientFilteringDAO clientFilteringDAO = new ClientFilteringDAO(jdbi);
        JdbiHistories histories = new JdbiHistories(jdbi);
        ClusterRepository clusterRepository = new ClusterRepository(clusterDAO, clientFilteringDAO, jdbi);
        ClusterModel model = clusterRepository.getCluster(this.clusterName);
        histories.removeByCluster(this.clusterName);
        Path path = this.initHomeDirectoryProvider().get().resolve("clc").resolve("configs").resolve(model.getId());
        ConsoleManager.removeConsoleConfig((Path)path);
        clusterRepository.remove(this.clusterName);
        this.printf("Successfully removed Cluster Config.%n", new Object[0]);
    }
}

