/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.cli;

import com.hazelcast.webmonitor.cli.BaseUserTask;
import com.hazelcast.webmonitor.cli.CliException;
import com.hazelcast.webmonitor.cli.IssueTokenTask;
import com.hazelcast.webmonitor.controller.dto.security.IssuedAuthTokenDTO;
import com.hazelcast.webmonitor.repositories.sql.AuthTokenDAO;
import com.hazelcast.webmonitor.security.spi.impl.builtin.DefaultSecurityProvider;
import com.hazelcast.webmonitor.service.AuthTokenManager;
import com.hazelcast.webmonitor.utils.SerializationUtil;
import java.io.PrintWriter;
import java.util.Optional;
import org.springframework.core.env.ConfigurableEnvironment;
import picocli.CommandLine;

@CommandLine.Command(description={"Issue a token for the given user in the Local security provider.%n*Important notice* Make sure that Management Center web application is stopped (offline) before starting this task.%n"}, mixinStandardHelpOptions=true, sortOptions=false)
class IssueTokenTask
extends BaseUserTask {
    @CommandLine.Option(names={"-n", "--username"}, required=true, paramLabel="<username>", description={"Username for the user record."})
    private String username;
    @CommandLine.Option(names={"-lb", "--label"}, paramLabel="<label>", description={"Description of the user token. Is generated as {username}_{creation_timestamp} if not provided"})
    private String label;
    @CommandLine.Option(names={"-of", "--output-format"}, paramLabel="<label>", description={"Output format of the user token. Valid values: ${COMPLETION-CANDIDATES}. Default: ${DEFAULT-VALUE}"})
    private OutputFormat outputFormat = OutputFormat.STANDARD;

    IssueTokenTask(PrintWriter out, ConfigurableEnvironment environment) {
        super(out, environment);
    }

    public void execute() {
        DefaultSecurityProvider securityProvider = this.initDefaultSecurityProvider(false);
        Optional user = securityProvider.getUser(this.username);
        if (!user.isPresent()) {
            throw new CliException(String.format("User record for username '%s' does not exist.", this.username));
        }
        try {
            AuthTokenManager authTokenManager = new AuthTokenManager(new AuthTokenDAO(this.initJdbi()));
            IssuedAuthTokenDTO token = authTokenManager.issue(this.username, this.label);
            this.auditService.log(this.logBuilder("MC-2004 [Auth]", "Issued auth token for user").parameter("targetUser", (Object)this.username).parameter("label", (Object)this.label).build());
            if (this.outputFormat == OutputFormat.JSON) {
                String tokenJson = SerializationUtil.OBJECT_MAPPER.writeValueAsString((Object)token);
                this.println(tokenJson);
            } else {
                this.printf("Successfully issued a token for user '%s'.%n", new Object[]{this.username});
                this.printf("Token: '%s'%nLabel: '%s' %n", new Object[]{token.getToken(), token.getLabel()});
            }
        }
        catch (Exception e) {
            throw new CliException(String.format("Could not issue a user token. Reason:%n%s", e.getMessage()), (Throwable)e);
        }
    }
}

