/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.cli;

import com.hazelcast.webmonitor.cli.BaseCliTask;
import com.hazelcast.webmonitor.cli.CliException;
import com.hazelcast.webmonitor.cli.EntityAlreadyExistsException;
import com.hazelcast.webmonitor.controller.dto.AddClusterRequestDTO;
import com.hazelcast.webmonitor.controller.exception.DuplicateRecordApiException;
import com.hazelcast.webmonitor.model.sql.ClusterModel;
import com.hazelcast.webmonitor.repositories.sql.ClientFilteringDAO;
import com.hazelcast.webmonitor.repositories.sql.ClusterDAO;
import com.hazelcast.webmonitor.repositories.sql.ClusterRepository;
import com.hazelcast.webmonitor.utils.StringUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import org.jdbi.v3.core.Jdbi;
import org.springframework.core.env.ConfigurableEnvironment;
import picocli.CommandLine;

@CommandLine.Command(description={"Add Cluster Connection Config. Newly added cluster connection is automatically enabled.%n*Important notice* Make sure that Management Center web application is stopped (offline) before starting this task.%n"}, mixinStandardHelpOptions=true, sortOptions=false)
public class AddClusterConfigTask
extends BaseCliTask {
    @CommandLine.Option(names={"-cn", "--cluster-name"}, paramLabel="<name>", description={"Cluster name. This option is mutually exclusive with Client Config."})
    private String clusterName;
    @CommandLine.Option(names={"-ma", "--member-addresses"}, paramLabel="<addresses>", description={"A comma-separated list of member addresses.This option is mutually exclusive with Client Config."})
    private String memberAddresses;
    @CommandLine.Option(names={"-cc", "--client-config"}, paramLabel="<path>", description={"Path for the Hazelcast IMDG Java client configuration file (XML or YAML). This option is mutually exclusive with Cluster Name."})
    private Path configPath;

    AddClusterConfigTask(PrintWriter out, ConfigurableEnvironment environment) {
        super(out, environment);
    }

    public void execute() {
        this.validate();
        Jdbi jdbi = this.initJdbi();
        ClusterDAO clusterDAO = new ClusterDAO(jdbi);
        ClientFilteringDAO clientFilteringDAO = new ClientFilteringDAO(jdbi);
        ClusterRepository clusterRepository = new ClusterRepository(clusterDAO, clientFilteringDAO, jdbi);
        try {
            if (!StringUtil.isNullOrEmptyAfterTrim((String)this.clusterName)) {
                this.addViaClusterName(clusterRepository);
            } else {
                this.addViaClientConfig(clusterRepository);
            }
        }
        catch (CliException e) {
            throw e;
        }
        catch (DuplicateRecordApiException e) {
            throw new EntityAlreadyExistsException("Cluster Config already exists for %s.", this.clusterName);
        }
        catch (Exception e) {
            throw new CliException("Could not add new Cluster Config. Reason: " + e.getMessage(), (Throwable)e);
        }
        this.printf("Successfully added Cluster Config.%n", new Object[0]);
    }

    private void validate() {
        if (StringUtil.isNullOrEmptyAfterTrim((String)this.clusterName) == (this.configPath == null)) {
            throw new CliException("One and only one of mandatory options (Cluster Name or Client Config) has to be specified.");
        }
        if (!StringUtil.isNullOrEmptyAfterTrim((String)this.clusterName) && StringUtil.isNullOrEmptyAfterTrim((String)this.memberAddresses)) {
            throw new CliException("Member addresses are not specified.");
        }
    }

    private void addViaClusterName(ClusterRepository clusterRepository) {
        AddClusterRequestDTO requestDTO = new AddClusterRequestDTO();
        requestDTO.setMemberAddresses(List.of(this.memberAddresses.split(",")));
        requestDTO.setName(this.clusterName);
        requestDTO.setEnabled(true);
        clusterRepository.add(requestDTO);
    }

    private void addViaClientConfig(ClusterRepository clusterRepository) {
        try {
            ClusterModel.ClientConfigType type = this.determineConfigType();
            byte[] fileBytes = Files.readAllBytes(this.configPath);
            clusterRepository.add(type, fileBytes, true);
        }
        catch (IOException e) {
            throw new CliException("Could not read client config.", (Throwable)e);
        }
    }

    private ClusterModel.ClientConfigType determineConfigType() {
        String path = this.configPath.toString().toLowerCase();
        if (path.endsWith(".xml")) {
            return ClusterModel.ClientConfigType.XML;
        }
        if (path.endsWith(".yml") || path.endsWith(".yaml")) {
            return ClusterModel.ClientConfigType.YAML;
        }
        throw new CliException("Unknown Client Config file type. XML or YAML file is expected.");
    }
}

