/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.jobhistory;

import java.util.Set;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.jobhistory.EventType;
import org.apache.hadoop.mapreduce.jobhistory.HistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobQueueChange;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEvent;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineMetric;

public class JobQueueChangeEvent
implements HistoryEvent {
    private JobQueueChange datum = new JobQueueChange();

    public JobQueueChangeEvent(JobID id, String queueName) {
        this.datum.setJobid(id.toString());
        this.datum.setJobQueueName(queueName);
    }

    JobQueueChangeEvent() {
    }

    @Override
    public EventType getEventType() {
        return EventType.JOB_QUEUE_CHANGED;
    }

    @Override
    public Object getDatum() {
        return this.datum;
    }

    @Override
    public void setDatum(Object datum) {
        this.datum = (JobQueueChange)datum;
    }

    public JobID getJobId() {
        return JobID.forName(this.datum.getJobid().toString());
    }

    public String getJobQueueName() {
        CharSequence jobQueueName = this.datum.getJobQueueName();
        if (jobQueueName != null) {
            return jobQueueName.toString();
        }
        return null;
    }

    @Override
    public TimelineEvent toTimelineEvent() {
        TimelineEvent tEvent = new TimelineEvent();
        tEvent.setId(StringUtils.toUpperCase(this.getEventType().name()));
        tEvent.addInfo("QUEUE_NAMES", (Object)this.getJobQueueName());
        return tEvent;
    }

    @Override
    public Set<TimelineMetric> getTimelineMetrics() {
        return null;
    }
}

