/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import org.apache.hadoop.fs.EtagSource;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;

public class VersionedFileStatus
extends FileStatus
implements EtagSource {
    private static final long serialVersionUID = -2009013240419749458L;
    private String version;
    private String encryptionContext;

    public VersionedFileStatus(String owner, String group, FsPermission fsPermission, boolean hasAcl, long length, boolean isdir, int blockReplication, long blocksize, long modificationTime, Path path, String version, String encryptionContext) {
        super(length, isdir, blockReplication, blocksize, modificationTime, 0L, fsPermission, owner, group, null, path, hasAcl, false, false);
        this.version = version;
        this.encryptionContext = encryptionContext;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof FileStatus)) {
            return false;
        }
        FileStatus other = (FileStatus)obj;
        if (!this.getPath().equals(other.getPath())) {
            return false;
        }
        if (other instanceof VersionedFileStatus) {
            return this.version.equals(((VersionedFileStatus)other).version);
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hash = this.getPath().hashCode();
        hash = 89 * hash + (this.version != null ? this.version.hashCode() : 0);
        return hash;
    }

    public String getVersion() {
        return this.version;
    }

    @Override
    public String getEtag() {
        return this.getVersion();
    }

    public String getEncryptionContext() {
        return this.encryptionContext;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("VersionedFileStatus{");
        sb.append(super.toString());
        sb.append("; version='").append(this.version).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

