/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.hadoop.fs.azurebfs.services.AbfsHttpOperation;
import org.apache.hadoop.fs.azurebfs.utils.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedKeyCredentials {
    private static final Logger LOG = LoggerFactory.getLogger(SharedKeyCredentials.class);
    private static final int EXPECTED_BLOB_QUEUE_CANONICALIZED_STRING_LENGTH = 300;
    private static final Pattern CRLF = Pattern.compile("\r\n", 16);
    private static final String HMAC_SHA256 = "HmacSHA256";
    private static final String RFC1123_PATTERN = "EEE, dd MMM yyyy HH:mm:ss z";
    private String accountName;
    private byte[] accountKey;
    private Mac hmacSha256;
    private static ThreadLocal<DateFormat> rfc1123GmtDateTimeFormatter = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            SimpleDateFormat formatter = new SimpleDateFormat(SharedKeyCredentials.RFC1123_PATTERN, Locale.ROOT);
            formatter.setTimeZone(GMT_ZONE);
            return formatter;
        }
    };
    public static final TimeZone GMT_ZONE = TimeZone.getTimeZone("GMT");

    public SharedKeyCredentials(String accountName, String accountKey) {
        if (accountName == null || accountName.isEmpty()) {
            throw new IllegalArgumentException("Invalid account name.");
        }
        if (accountKey == null || accountKey.isEmpty()) {
            throw new IllegalArgumentException("Invalid account key.");
        }
        this.accountName = accountName;
        this.accountKey = Base64.decode(accountKey);
        this.initializeMac();
    }

    public void signRequest(AbfsHttpOperation connection, long contentLength) throws UnsupportedEncodingException {
        String gmtTime = SharedKeyCredentials.getGMTTime();
        connection.setRequestProperty("x-ms-date", gmtTime);
        String stringToSign = this.canonicalize(connection, this.accountName, contentLength);
        String computedBase64Signature = this.computeHmac256(stringToSign);
        String signature = String.format("%s %s:%s", "SharedKey", this.accountName, computedBase64Signature);
        connection.setRequestProperty("Authorization", signature);
        LOG.debug("Signing request with timestamp of {} and signature {}", (Object)gmtTime, (Object)signature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String computeHmac256(String stringToSign) {
        byte[] hmac;
        byte[] utf8Bytes;
        try {
            utf8Bytes = stringToSign.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
        SharedKeyCredentials sharedKeyCredentials = this;
        synchronized (sharedKeyCredentials) {
            hmac = this.hmacSha256.doFinal(utf8Bytes);
        }
        return Base64.encode(hmac);
    }

    private static void addCanonicalizedHeaders(AbfsHttpOperation conn, StringBuilder canonicalizedString) {
        Map<String, List<String>> headers = conn.getRequestProperties();
        ArrayList<String> httpStorageHeaderNameArray = new ArrayList<String>();
        for (String key : headers.keySet()) {
            if (!key.toLowerCase(Locale.ROOT).startsWith("x-ms-")) continue;
            httpStorageHeaderNameArray.add(key.toLowerCase(Locale.ROOT));
        }
        Collections.sort(httpStorageHeaderNameArray);
        for (String key : httpStorageHeaderNameArray) {
            StringBuilder canonicalizedElement = new StringBuilder(key);
            String delimiter = ":";
            ArrayList<String> values = SharedKeyCredentials.getHeaderValues(headers, key);
            boolean appendCanonicalizedElement = false;
            for (String value : values) {
                if (value != null) {
                    appendCanonicalizedElement = true;
                }
                String unfoldedValue = CRLF.matcher(value).replaceAll(Matcher.quoteReplacement(""));
                canonicalizedElement.append(delimiter);
                canonicalizedElement.append(unfoldedValue);
                delimiter = ",";
            }
            if (!appendCanonicalizedElement) continue;
            SharedKeyCredentials.appendCanonicalizedElement(canonicalizedString, canonicalizedElement.toString());
        }
    }

    private void initializeMac() {
        try {
            this.hmacSha256 = Mac.getInstance(HMAC_SHA256);
            this.hmacSha256.init(new SecretKeySpec(this.accountKey, HMAC_SHA256));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static void appendCanonicalizedElement(StringBuilder builder, String element) {
        builder.append("\n");
        builder.append(element);
    }

    private static String canonicalizeHttpRequest(URL address, String accountName, String method, String contentType, long contentLength, String date, AbfsHttpOperation conn) throws UnsupportedEncodingException {
        StringBuilder canonicalizedString = new StringBuilder(300);
        canonicalizedString.append(conn.getMethod());
        SharedKeyCredentials.appendCanonicalizedElement(canonicalizedString, SharedKeyCredentials.getHeaderValue(conn, "Content-Encoding", ""));
        SharedKeyCredentials.appendCanonicalizedElement(canonicalizedString, SharedKeyCredentials.getHeaderValue(conn, "Content-Language", ""));
        SharedKeyCredentials.appendCanonicalizedElement(canonicalizedString, contentLength <= 0L ? "" : String.valueOf(contentLength));
        SharedKeyCredentials.appendCanonicalizedElement(canonicalizedString, SharedKeyCredentials.getHeaderValue(conn, "Content-MD5", ""));
        SharedKeyCredentials.appendCanonicalizedElement(canonicalizedString, contentType != null ? contentType : "");
        String dateString = SharedKeyCredentials.getHeaderValue(conn, "x-ms-date", "");
        SharedKeyCredentials.appendCanonicalizedElement(canonicalizedString, dateString.equals("") ? date : "");
        SharedKeyCredentials.appendCanonicalizedElement(canonicalizedString, SharedKeyCredentials.getHeaderValue(conn, "If-Modified-Since", ""));
        SharedKeyCredentials.appendCanonicalizedElement(canonicalizedString, SharedKeyCredentials.getHeaderValue(conn, "If-Match", ""));
        SharedKeyCredentials.appendCanonicalizedElement(canonicalizedString, SharedKeyCredentials.getHeaderValue(conn, "If-None-Match", ""));
        SharedKeyCredentials.appendCanonicalizedElement(canonicalizedString, SharedKeyCredentials.getHeaderValue(conn, "If-Unmodified-Since", ""));
        SharedKeyCredentials.appendCanonicalizedElement(canonicalizedString, SharedKeyCredentials.getHeaderValue(conn, "Range", ""));
        SharedKeyCredentials.addCanonicalizedHeaders(conn, canonicalizedString);
        SharedKeyCredentials.appendCanonicalizedElement(canonicalizedString, SharedKeyCredentials.getCanonicalizedResource(address, accountName));
        return canonicalizedString.toString();
    }

    private static String getCanonicalizedResource(URL address, String accountName) throws UnsupportedEncodingException {
        StringBuilder resourcepath = new StringBuilder("/");
        resourcepath.append(accountName);
        resourcepath.append(address.getPath());
        StringBuilder canonicalizedResource = new StringBuilder(resourcepath.toString());
        if (address.getQuery() == null || !address.getQuery().contains("=")) {
            return canonicalizedResource.toString();
        }
        HashMap<String, String[]> queryVariables = SharedKeyCredentials.parseQueryString(address.getQuery());
        HashMap<String, String> lowercasedKeyNameValue = new HashMap<String, String>();
        for (Map.Entry entry : queryVariables.entrySet()) {
            List<Object> sortedValues = Arrays.asList((Object[])entry.getValue());
            Collections.sort(sortedValues);
            StringBuilder stringValue = new StringBuilder();
            for (String string : sortedValues) {
                if (stringValue.length() > 0) {
                    stringValue.append(",");
                }
                stringValue.append(string);
            }
            lowercasedKeyNameValue.put(entry.getKey() == null ? null : ((String)entry.getKey()).toLowerCase(Locale.ROOT), stringValue.toString());
        }
        ArrayList sortedKeys = new ArrayList(lowercasedKeyNameValue.keySet());
        Collections.sort(sortedKeys);
        for (String key : sortedKeys) {
            StringBuilder queryParamString = new StringBuilder();
            queryParamString.append(key);
            queryParamString.append(":");
            queryParamString.append((String)lowercasedKeyNameValue.get(key));
            SharedKeyCredentials.appendCanonicalizedElement(canonicalizedResource, queryParamString.toString());
        }
        return canonicalizedResource.toString();
    }

    private static ArrayList<String> getHeaderValues(Map<String, List<String>> headers, String headerName) {
        ArrayList<String> arrayOfValues = new ArrayList<String>();
        List<String> values = null;
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            if (!entry.getKey().toLowerCase(Locale.ROOT).equals(headerName)) continue;
            values = entry.getValue();
            break;
        }
        if (values != null) {
            for (String value : values) {
                arrayOfValues.add(SharedKeyCredentials.trimStart(value));
            }
        }
        return arrayOfValues;
    }

    private static HashMap<String, String[]> parseQueryString(String parseString) throws UnsupportedEncodingException {
        HashMap<String, String[]> retVals = new HashMap<String, String[]>();
        if (parseString == null || parseString.isEmpty()) {
            return retVals;
        }
        int queryDex = parseString.indexOf("?");
        if (queryDex >= 0 && parseString.length() > 0) {
            parseString = parseString.substring(queryDex + 1);
        }
        String[] valuePairs = parseString.contains("&") ? parseString.split("&") : parseString.split(";");
        for (int m4 = 0; m4 < valuePairs.length; ++m4) {
            int equalDex = valuePairs[m4].indexOf("=");
            if (equalDex < 0 || equalDex == valuePairs[m4].length() - 1) continue;
            String key = valuePairs[m4].substring(0, equalDex);
            String value = valuePairs[m4].substring(equalDex + 1);
            key = SharedKeyCredentials.safeDecode(key);
            value = SharedKeyCredentials.safeDecode(value);
            String[] values = retVals.get(key);
            if (values != null) continue;
            values = new String[]{value};
            if (value.equals("")) continue;
            retVals.put(key, values);
        }
        return retVals;
    }

    private static String safeDecode(String stringToDecode) throws UnsupportedEncodingException {
        if (stringToDecode == null) {
            return null;
        }
        if (stringToDecode.length() == 0) {
            return "";
        }
        if (stringToDecode.contains("+")) {
            StringBuilder outBuilder = new StringBuilder();
            int startDex = 0;
            for (int m4 = 0; m4 < stringToDecode.length(); ++m4) {
                if (stringToDecode.charAt(m4) != '+') continue;
                if (m4 > startDex) {
                    outBuilder.append(URLDecoder.decode(stringToDecode.substring(startDex, m4), "utf-8"));
                }
                outBuilder.append("+");
                startDex = m4 + 1;
            }
            if (startDex != stringToDecode.length()) {
                outBuilder.append(URLDecoder.decode(stringToDecode.substring(startDex, stringToDecode.length()), "utf-8"));
            }
            return outBuilder.toString();
        }
        return URLDecoder.decode(stringToDecode, "utf-8");
    }

    private static String trimStart(String value) {
        int spaceDex;
        for (spaceDex = 0; spaceDex < value.length() && value.charAt(spaceDex) == ' '; ++spaceDex) {
        }
        return value.substring(spaceDex);
    }

    private static String getHeaderValue(AbfsHttpOperation conn, String headerName, String defaultValue) {
        String headerValue = conn.getRequestProperty(headerName);
        return headerValue == null ? defaultValue : headerValue;
    }

    private String canonicalize(AbfsHttpOperation conn, String accountName, Long contentLength) throws UnsupportedEncodingException {
        if (contentLength < -1L) {
            throw new IllegalArgumentException("The Content-Length header must be greater than or equal to -1.");
        }
        String contentType = SharedKeyCredentials.getHeaderValue(conn, "Content-Type", "");
        return SharedKeyCredentials.canonicalizeHttpRequest(conn.getConnUrl(), accountName, conn.getMethod(), contentType, contentLength, null, conn);
    }

    static String getGMTTime() {
        return SharedKeyCredentials.getGMTTime(new Date());
    }

    static String getGMTTime(Date date) {
        return rfc1123GmtDateTimeFormatter.get().format(date);
    }
}

