/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.net.UnknownHostException;
import java.time.Duration;
import java.util.List;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.fs.ClosedIOException;
import org.apache.hadoop.fs.azurebfs.AbfsConfiguration;
import org.apache.hadoop.fs.azurebfs.AbfsStatistic;
import org.apache.hadoop.fs.azurebfs.constants.HttpOperationType;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AbfsDriverException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AbfsRestOperationException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AzureBlobFileSystemException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.InvalidAbfsRestOperationException;
import org.apache.hadoop.fs.azurebfs.contracts.services.AzureServiceErrorCode;
import org.apache.hadoop.fs.azurebfs.contracts.services.ListResultSchema;
import org.apache.hadoop.fs.azurebfs.enums.AbfsBackoffMetricsEnum;
import org.apache.hadoop.fs.azurebfs.enums.RetryValue;
import org.apache.hadoop.fs.azurebfs.services.AbfsAHCHttpOperation;
import org.apache.hadoop.fs.azurebfs.services.AbfsApacheHttpClient;
import org.apache.hadoop.fs.azurebfs.services.AbfsBackoffMetrics;
import org.apache.hadoop.fs.azurebfs.services.AbfsClient;
import org.apache.hadoop.fs.azurebfs.services.AbfsCounters;
import org.apache.hadoop.fs.azurebfs.services.AbfsHttpHeader;
import org.apache.hadoop.fs.azurebfs.services.AbfsHttpOperation;
import org.apache.hadoop.fs.azurebfs.services.AbfsIoUtils;
import org.apache.hadoop.fs.azurebfs.services.AbfsJdkHttpOperation;
import org.apache.hadoop.fs.azurebfs.services.AbfsRestOperationType;
import org.apache.hadoop.fs.azurebfs.services.AbfsRetryPolicy;
import org.apache.hadoop.fs.azurebfs.services.AbfsThrottlingIntercept;
import org.apache.hadoop.fs.azurebfs.services.RetryReason;
import org.apache.hadoop.fs.azurebfs.services.TimerFunctionality;
import org.apache.hadoop.fs.azurebfs.utils.TracingContext;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsBinding;
import org.apache.hadoop.util.Time;
import org.apache.http.impl.execchain.RequestAbortedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbfsRestOperation {
    private final AbfsRestOperationType operationType;
    private final AbfsClient client;
    private final AbfsThrottlingIntercept intercept;
    private final String method;
    private final URL url;
    private final List<AbfsHttpHeader> requestHeaders;
    private final boolean hasRequestBody;
    private final String sasToken;
    private static final Logger LOG = LoggerFactory.getLogger(AbfsClient.class);
    private static final Logger LOG1 = LoggerFactory.getLogger(AbfsRestOperation.class);
    private byte[] buffer;
    private int bufferOffset;
    private int bufferLength;
    private int retryCount = 0;
    private boolean isThrottledRequest = false;
    private long maxRetryCount = 0L;
    private final int maxIoRetries;
    private AbfsHttpOperation result;
    private final AbfsCounters abfsCounters;
    private AbfsBackoffMetrics abfsBackoffMetrics;
    private String failureReason;
    private AbfsRetryPolicy retryPolicy;
    private final AbfsConfiguration abfsConfiguration;
    private TracingContext lastUsedTracingContext;
    private int apacheHttpClientIoExceptions = 0;
    private static final int MIN_FIRST_RANGE = 1;
    private static final int MAX_FIRST_RANGE = 5;
    private static final int MAX_SECOND_RANGE = 15;
    private static final int MAX_THIRD_RANGE = 25;

    public boolean hasResult() {
        return this.result != null;
    }

    public AbfsHttpOperation getResult() {
        return this.result;
    }

    public void hardSetResult(int httpStatus) {
        this.result = AbfsHttpOperation.getAbfsHttpOperationWithFixedResult(this.url, this.method, httpStatus);
    }

    public void hardSetGetFileStatusResult(int httpStatus) {
        this.result = new AbfsHttpOperation.AbfsHttpOperationWithFixedResultForGetFileStatus(this.url, this.method, httpStatus);
    }

    public void hardSetGetListStatusResult(int httpStatus, ListResultSchema listResultSchema) {
        this.result = new AbfsHttpOperation.AbfsHttpOperationWithFixedResultForGetListStatus(this.url, this.method, httpStatus, listResultSchema);
    }

    public URL getUrl() {
        return this.url;
    }

    public List<AbfsHttpHeader> getRequestHeaders() {
        return this.requestHeaders;
    }

    public boolean isARetriedRequest() {
        return this.retryCount > 0;
    }

    String getSasToken() {
        return this.sasToken;
    }

    AbfsRestOperation(AbfsRestOperationType operationType, AbfsClient client, String method, URL url, List<AbfsHttpHeader> requestHeaders, AbfsConfiguration abfsConfiguration) {
        this(operationType, client, method, url, requestHeaders, null, abfsConfiguration);
    }

    AbfsRestOperation(AbfsRestOperationType operationType, AbfsClient client, String method, URL url, List<AbfsHttpHeader> requestHeaders, String sasToken, AbfsConfiguration abfsConfiguration) {
        this.operationType = operationType;
        this.client = client;
        this.method = method;
        this.url = url;
        this.requestHeaders = requestHeaders;
        this.hasRequestBody = "PUT".equals(method) || "POST".equals(method) || "PATCH".equals(method);
        this.sasToken = sasToken;
        this.abfsCounters = client.getAbfsCounters();
        if (this.abfsCounters != null) {
            this.abfsBackoffMetrics = this.abfsCounters.getAbfsBackoffMetrics();
        }
        this.maxIoRetries = abfsConfiguration.getMaxIoRetries();
        this.intercept = client.getIntercept();
        this.abfsConfiguration = abfsConfiguration;
        this.retryPolicy = client.getExponentialRetryPolicy();
    }

    AbfsRestOperation(AbfsRestOperationType operationType, AbfsClient client, String method, URL url, List<AbfsHttpHeader> requestHeaders, byte[] buffer, int bufferOffset, int bufferLength, String sasToken, AbfsConfiguration abfsConfiguration) {
        this(operationType, client, method, url, requestHeaders, sasToken, abfsConfiguration);
        this.buffer = buffer;
        this.bufferOffset = bufferOffset;
        this.bufferLength = bufferLength;
    }

    public void execute(TracingContext tracingContext) throws AzureBlobFileSystemException {
        this.lastUsedTracingContext = this.createNewTracingContext(tracingContext);
        try {
            if (this.abfsCounters != null) {
                this.abfsCounters.getLastExecutionTime().set(Time.now());
            }
            this.client.timerOrchestrator(TimerFunctionality.RESUME, null);
            IOStatisticsBinding.trackDurationOfInvocation(this.abfsCounters, AbfsStatistic.getStatNameFromHttpCall(this.method), () -> this.completeExecute(this.lastUsedTracingContext));
        }
        catch (AzureBlobFileSystemException aze) {
            throw aze;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Error while tracking Duration of an AbfsRestOperation call", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void completeExecute(TracingContext tracingContext) throws AzureBlobFileSystemException {
        int status;
        String latencyHeader = this.getClientLatency();
        if (latencyHeader != null && !latencyHeader.isEmpty()) {
            AbfsHttpHeader httpHeader = new AbfsHttpHeader("x-ms-abfs-client-latency", latencyHeader);
            this.requestHeaders.add(httpHeader);
        }
        this.retryCount = 0;
        this.retryPolicy = this.client.getExponentialRetryPolicy();
        LOG.debug("First execution of REST operation - {}", (Object)this.operationType);
        long sleepDuration = 0L;
        if (this.abfsBackoffMetrics != null) {
            AbfsRestOperation abfsRestOperation = this;
            synchronized (abfsRestOperation) {
                this.abfsBackoffMetrics.incrementMetricValue(AbfsBackoffMetricsEnum.TOTAL_NUMBER_OF_REQUESTS);
            }
        }
        while (!this.executeHttpOperation(this.retryCount, tracingContext)) {
            try {
                ++this.retryCount;
                tracingContext.setRetryCount(this.retryCount);
                long retryInterval = this.retryPolicy.getRetryInterval(this.retryCount);
                LOG.debug("Rest operation {} failed with failureReason: {}. Retrying with retryCount = {}, retryPolicy: {} and sleepInterval: {}", new Object[]{this.operationType, this.failureReason, this.retryCount, this.retryPolicy.getAbbreviation(), retryInterval});
                if (this.abfsBackoffMetrics != null) {
                    this.updateBackoffTimeMetrics(this.retryCount, sleepDuration);
                }
                Thread.sleep(retryInterval);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
        if (this.abfsBackoffMetrics != null) {
            this.updateBackoffMetrics(this.retryCount, this.result.getStatusCode());
        }
        if ((status = this.result.getStatusCode()) < 100) {
            throw new InvalidAbfsRestOperationException(null, this.retryCount);
        }
        if (status >= 400) {
            throw new AbfsRestOperationException(this.result.getStatusCode(), this.result.getStorageErrorCode(), this.result.getStorageErrorMessage(), null, this.result);
        }
        LOG.trace("{} REST operation complete", (Object)this.operationType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void updateBackoffMetrics(int retryCount, int statusCode) {
        if (this.abfsBackoffMetrics != null) {
            if (statusCode < 200 || statusCode >= 500) {
                AbfsRestOperation abfsRestOperation = this;
                synchronized (abfsRestOperation) {
                    if (retryCount >= this.maxIoRetries) {
                        this.abfsBackoffMetrics.incrementMetricValue(AbfsBackoffMetricsEnum.NUMBER_OF_REQUESTS_FAILED);
                    }
                }
            }
            AbfsRestOperation abfsRestOperation = this;
            synchronized (abfsRestOperation) {
                if (retryCount > 0 && retryCount <= this.maxIoRetries) {
                    this.maxRetryCount = Math.max(this.abfsBackoffMetrics.getMetricValue(AbfsBackoffMetricsEnum.MAX_RETRY_COUNT), (long)retryCount);
                    this.abfsBackoffMetrics.setMetricValue(AbfsBackoffMetricsEnum.MAX_RETRY_COUNT, this.maxRetryCount);
                    this.updateCount(retryCount);
                } else {
                    this.abfsBackoffMetrics.incrementMetricValue(AbfsBackoffMetricsEnum.NUMBER_OF_REQUESTS_SUCCEEDED_WITHOUT_RETRYING);
                }
            }
        }
    }

    @VisibleForTesting
    String getClientLatency() {
        return this.client.getAbfsPerfTracker().getClientLatency();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeHttpOperation(int retryCount, TracingContext tracingContext) throws AzureBlobFileSystemException {
        AbfsRestOperation abfsRestOperation;
        AbfsHttpOperation httpOperation;
        boolean wasKnownExceptionThrown = false;
        try {
            httpOperation = this.createHttpOperation();
            this.incrementCounter(AbfsStatistic.CONNECTIONS_MADE, 1L);
            tracingContext.constructHeader(httpOperation, this.failureReason, this.retryPolicy.getAbbreviation());
            this.signRequest(httpOperation, this.hasRequestBody ? this.bufferLength : 0);
        }
        catch (IOException e) {
            LOG.debug("Auth failure: {}, {}", (Object)this.method, (Object)this.url);
            throw new AbfsRestOperationException(-1, null, "Auth failure: " + e.getMessage(), e);
        }
        try {
            AbfsIoUtils.dumpHeadersToDebugLog("Request Headers", httpOperation.getRequestProperties());
            this.intercept.sendingRequest(this.operationType, this.abfsCounters);
            if (this.hasRequestBody) {
                httpOperation.sendPayload(this.buffer, this.bufferOffset, this.bufferLength);
                this.incrementCounter(AbfsStatistic.SEND_REQUESTS, 1L);
                if (!this.operationType.name().equals("PutBlockList")) {
                    this.incrementCounter(AbfsStatistic.BYTES_SENT, this.bufferLength);
                }
            }
            httpOperation.processResponse(this.buffer, this.bufferOffset, this.bufferLength);
            if (!this.isThrottledRequest && httpOperation.getStatusCode() >= 500) {
                this.isThrottledRequest = true;
                AzureServiceErrorCode serviceErrorCode = AzureServiceErrorCode.getAzureServiceCode(httpOperation.getStatusCode(), httpOperation.getStorageErrorCode(), httpOperation.getStorageErrorMessage());
                LOG1.trace("Service code is " + (Object)((Object)serviceErrorCode) + " status code is " + httpOperation.getStatusCode() + " error code is " + httpOperation.getStorageErrorCode() + " error message is " + httpOperation.getStorageErrorMessage());
                if (this.abfsBackoffMetrics != null) {
                    abfsRestOperation = this;
                    synchronized (abfsRestOperation) {
                        if (serviceErrorCode.equals((Object)AzureServiceErrorCode.INGRESS_OVER_ACCOUNT_LIMIT) || serviceErrorCode.equals((Object)AzureServiceErrorCode.EGRESS_OVER_ACCOUNT_LIMIT)) {
                            this.abfsBackoffMetrics.incrementMetricValue(AbfsBackoffMetricsEnum.NUMBER_OF_BANDWIDTH_THROTTLED_REQUESTS);
                        } else if (serviceErrorCode.equals((Object)AzureServiceErrorCode.TPS_OVER_ACCOUNT_LIMIT)) {
                            this.abfsBackoffMetrics.incrementMetricValue(AbfsBackoffMetricsEnum.NUMBER_OF_IOPS_THROTTLED_REQUESTS);
                        } else {
                            this.abfsBackoffMetrics.incrementMetricValue(AbfsBackoffMetricsEnum.NUMBER_OF_OTHER_THROTTLED_REQUESTS);
                        }
                    }
                }
            }
            this.incrementCounter(AbfsStatistic.GET_RESPONSES, 1L);
            if (httpOperation.getStatusCode() >= 200 && httpOperation.getStatusCode() <= 206) {
                this.incrementCounter(AbfsStatistic.BYTES_RECEIVED, httpOperation.getBytesReceived());
            } else if (httpOperation.getStatusCode() == 503) {
                this.incrementCounter(AbfsStatistic.SERVER_UNAVAILABLE, 1L);
            }
            LOG.debug("HttpRequest: {}: {}", (Object)this.operationType, (Object)httpOperation);
            int status = httpOperation.getStatusCode();
            this.failureReason = RetryReason.getAbbreviation(null, status, httpOperation.getStorageErrorMessage());
            this.retryPolicy = this.client.getRetryPolicy(this.failureReason);
            if (this.retryPolicy.shouldRetry(retryCount, httpOperation.getStatusCode())) {
                boolean bl = false;
                return bl;
            }
            this.result = httpOperation;
        }
        catch (UnknownHostException ex) {
            wasKnownExceptionThrown = true;
            String hostname = null;
            hostname = httpOperation.getHost();
            this.failureReason = RetryReason.getAbbreviation(ex, null, null);
            this.retryPolicy = this.client.getRetryPolicy(this.failureReason);
            LOG.warn("Unknown host name: {}. Retrying to resolve the host name...", (Object)hostname);
            if (httpOperation instanceof AbfsAHCHttpOperation) {
                this.registerApacheHttpClientIoException();
            }
            if (this.abfsBackoffMetrics != null) {
                AbfsRestOperation statusCode = this;
                synchronized (statusCode) {
                    this.abfsBackoffMetrics.incrementMetricValue(AbfsBackoffMetricsEnum.NUMBER_OF_NETWORK_FAILED_REQUESTS);
                }
            }
            if (!this.retryPolicy.shouldRetry(retryCount, -1)) {
                this.updateBackoffMetrics(retryCount, httpOperation.getStatusCode());
                throw new InvalidAbfsRestOperationException(ex, retryCount);
            }
            boolean statusCode = false;
            return statusCode;
        }
        catch (IOException ex) {
            wasKnownExceptionThrown = true;
            if (LOG.isDebugEnabled()) {
                LOG.debug("HttpRequestFailure: {}, {}", (Object)httpOperation, (Object)ex);
            }
            if (this.abfsBackoffMetrics != null) {
                abfsRestOperation = this;
                synchronized (abfsRestOperation) {
                    this.abfsBackoffMetrics.incrementMetricValue(AbfsBackoffMetricsEnum.NUMBER_OF_NETWORK_FAILED_REQUESTS);
                }
            }
            this.failureReason = RetryReason.getAbbreviation(ex, -1, "");
            this.retryPolicy = this.client.getRetryPolicy(this.failureReason);
            if (httpOperation instanceof AbfsAHCHttpOperation) {
                this.registerApacheHttpClientIoException();
                if (ex instanceof RequestAbortedException && ex.getCause() instanceof ClosedIOException) {
                    throw new AbfsDriverException((IOException)ex.getCause());
                }
            }
            if (!this.retryPolicy.shouldRetry(retryCount, -1)) {
                this.updateBackoffMetrics(retryCount, httpOperation.getStatusCode());
                throw new InvalidAbfsRestOperationException(ex, retryCount);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            int statusCode = httpOperation.getStatusCode();
            if (this.shouldUpdateCSTMetrics(statusCode) && !wasKnownExceptionThrown) {
                this.intercept.updateMetrics(this.operationType, httpOperation);
            }
        }
        return true;
    }

    private void registerApacheHttpClientIoException() {
        ++this.apacheHttpClientIoExceptions;
        if (this.apacheHttpClientIoExceptions >= this.abfsConfiguration.getMaxApacheHttpClientIoExceptionsRetries()) {
            AbfsApacheHttpClient.registerFallback();
        }
    }

    @VisibleForTesting
    public void signRequest(AbfsHttpOperation httpOperation, int bytesToSign) throws IOException {
        if (this.client.isSendMetricCall()) {
            this.client.getMetricSharedkeyCredentials().signRequest(httpOperation, bytesToSign);
        } else {
            switch (this.client.getAuthType()) {
                case Custom: 
                case OAuth: {
                    LOG.debug("Authenticating request with OAuth2 access token");
                    httpOperation.setRequestProperty("Authorization", this.client.getAccessToken());
                    break;
                }
                case SAS: {
                    httpOperation.setMaskForSAS();
                    break;
                }
                default: {
                    LOG.debug("Signing request with shared key");
                    this.client.getSharedKeyCredentials().signRequest(httpOperation, bytesToSign);
                }
            }
        }
    }

    @VisibleForTesting
    AbfsHttpOperation createHttpOperation() throws IOException {
        HttpOperationType httpOperationType = this.abfsConfiguration.getPreferredHttpOperationType();
        if (httpOperationType == HttpOperationType.APACHE_HTTP_CLIENT && this.isApacheClientUsable()) {
            return this.createAbfsAHCHttpOperation();
        }
        return this.createAbfsHttpOperation();
    }

    private boolean isApacheClientUsable() {
        return AbfsApacheHttpClient.usable();
    }

    @VisibleForTesting
    AbfsJdkHttpOperation createAbfsHttpOperation() throws IOException {
        return new AbfsJdkHttpOperation(this.url, this.method, this.requestHeaders, Duration.ofMillis(this.client.getAbfsConfiguration().getHttpConnectionTimeout()), Duration.ofMillis(this.client.getAbfsConfiguration().getHttpReadTimeout()), this.client);
    }

    @VisibleForTesting
    AbfsAHCHttpOperation createAbfsAHCHttpOperation() throws IOException {
        return new AbfsAHCHttpOperation(this.url, this.method, this.requestHeaders, Duration.ofMillis(this.client.getAbfsConfiguration().getHttpConnectionTimeout()), Duration.ofMillis(this.client.getAbfsConfiguration().getHttpReadTimeout()), this.client.getAbfsApacheHttpClient(), this.client);
    }

    private void incrementCounter(AbfsStatistic statistic, long value) {
        if (this.abfsCounters != null) {
            this.abfsCounters.incrementCounter(statistic, value);
        }
    }

    private void updateCount(int retryCount) {
        this.abfsBackoffMetrics.incrementMetricValue(AbfsBackoffMetricsEnum.NUMBER_OF_REQUESTS_SUCCEEDED, RetryValue.getRetryValue(retryCount));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateBackoffTimeMetrics(int retryCount, long sleepDuration) {
        AbfsRestOperation abfsRestOperation = this;
        synchronized (abfsRestOperation) {
            RetryValue retryCounter = RetryValue.getRetryValue(retryCount);
            long minBackoffTime = Math.min(this.abfsBackoffMetrics.getMetricValue(AbfsBackoffMetricsEnum.MIN_BACK_OFF, retryCounter), sleepDuration);
            long maxBackoffForTime = Math.max(this.abfsBackoffMetrics.getMetricValue(AbfsBackoffMetricsEnum.MAX_BACK_OFF, retryCounter), sleepDuration);
            long totalBackoffTime = this.abfsBackoffMetrics.getMetricValue(AbfsBackoffMetricsEnum.TOTAL_BACK_OFF, retryCounter) + sleepDuration;
            this.abfsBackoffMetrics.incrementMetricValue(AbfsBackoffMetricsEnum.TOTAL_REQUESTS, retryCounter);
            this.abfsBackoffMetrics.setMetricValue(AbfsBackoffMetricsEnum.MIN_BACK_OFF, minBackoffTime, retryCounter);
            this.abfsBackoffMetrics.setMetricValue(AbfsBackoffMetricsEnum.MAX_BACK_OFF, maxBackoffForTime, retryCounter);
            this.abfsBackoffMetrics.setMetricValue(AbfsBackoffMetricsEnum.TOTAL_BACK_OFF, totalBackoffTime, retryCounter);
        }
    }

    private boolean shouldUpdateCSTMetrics(int statusCode) {
        return statusCode < 300 || "ING".equals(this.failureReason) || "EGR".equals(this.failureReason) || "OPR".equals(this.failureReason);
    }

    @VisibleForTesting
    public TracingContext createNewTracingContext(TracingContext tracingContext) {
        return new TracingContext(tracingContext);
    }

    @VisibleForTesting
    public final TracingContext getLastTracingContext() {
        return this.lastUsedTracingContext;
    }

    int getRetryCount() {
        return this.retryCount;
    }
}

