/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import org.apache.hadoop.fs.azurebfs.enums.AbfsReadFooterMetricsEnum;
import org.apache.hadoop.fs.azurebfs.enums.FileType;
import org.apache.hadoop.fs.azurebfs.enums.StatisticTypeEnum;
import org.apache.hadoop.fs.azurebfs.services.AbstractAbfsStatisticsSource;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsBinding;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsStore;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbfsReadFooterMetrics
extends AbstractAbfsStatisticsSource {
    private static final Logger LOG = LoggerFactory.getLogger(AbfsReadFooterMetrics.class);
    private static final String FOOTER_LENGTH = "20";
    private static final List<FileType> FILE_TYPE_LIST = Arrays.asList(FileType.values());
    private final Map<String, FileTypeMetrics> fileTypeMetricsMap = new ConcurrentHashMap<String, FileTypeMetrics>();

    public AbfsReadFooterMetrics() {
        IOStatisticsStore ioStatisticsStore = IOStatisticsBinding.iostatisticsStore().withCounters(this.getMetricNames(StatisticTypeEnum.TYPE_COUNTER)).withMeanStatistics(this.getMetricNames(StatisticTypeEnum.TYPE_MEAN)).build();
        this.setIOStatistics(ioStatisticsStore);
    }

    private String[] getMetricNames(StatisticTypeEnum type) {
        return (String[])Arrays.stream(AbfsReadFooterMetricsEnum.values()).filter(readFooterMetricsEnum -> readFooterMetricsEnum.getStatisticType().equals((Object)type)).flatMap(readFooterMetricsEnum -> "FILE".equals(readFooterMetricsEnum.getType()) ? FILE_TYPE_LIST.stream().map(fileType -> this.getMetricName((FileType)((Object)((Object)fileType)), (AbfsReadFooterMetricsEnum)((Object)readFooterMetricsEnum))) : Stream.of(readFooterMetricsEnum.getName())).toArray(String[]::new);
    }

    private String getMetricName(FileType fileType, AbfsReadFooterMetricsEnum readFooterMetricsEnum) {
        if (fileType == null || readFooterMetricsEnum == null) {
            LOG.error("File type or ABFS read footer metrics should not be null");
            return "";
        }
        return (Object)((Object)fileType) + ":" + readFooterMetricsEnum.getName();
    }

    private long getCounterMetricValue(FileType fileType, AbfsReadFooterMetricsEnum abfsReadFooterMetricsEnum) {
        return this.lookupCounterValue(this.getMetricName(fileType, abfsReadFooterMetricsEnum));
    }

    private String getMeanMetricValue(FileType fileType, AbfsReadFooterMetricsEnum abfsReadFooterMetricsEnum) {
        return StringUtils.format("%.3f", this.lookupMeanStatistic(this.getMetricName(fileType, abfsReadFooterMetricsEnum)));
    }

    public void incrementMetricValue(FileType fileType, AbfsReadFooterMetricsEnum abfsReadFooterMetricsEnum) {
        this.incCounterValue(this.getMetricName(fileType, abfsReadFooterMetricsEnum));
    }

    public void addMeanMetricValue(FileType fileType, AbfsReadFooterMetricsEnum abfsReadFooterMetricsEnum, long value) {
        this.addMeanStatistic(this.getMetricName(fileType, abfsReadFooterMetricsEnum), value);
    }

    public Long getTotalFiles() {
        return this.getCounterMetricValue(FileType.PARQUET, AbfsReadFooterMetricsEnum.TOTAL_FILES) + this.getCounterMetricValue(FileType.NON_PARQUET, AbfsReadFooterMetricsEnum.TOTAL_FILES);
    }

    public void updateMap(String filePathIdentifier) {
        this.fileTypeMetricsMap.computeIfAbsent(filePathIdentifier, key -> new FileTypeMetrics());
    }

    public void updateReadMetrics(String filePathIdentifier, int len, long contentLength, long nextReadPos) {
        FileTypeMetrics fileTypeMetrics = this.fileTypeMetricsMap.computeIfAbsent(filePathIdentifier, key -> new FileTypeMetrics());
        if (fileTypeMetrics.getReadCount() == 0L || fileTypeMetrics.getReadCount() >= 1L && fileTypeMetrics.getCollectMetrics()) {
            this.updateMetrics(fileTypeMetrics, len, contentLength, nextReadPos);
        }
    }

    private void updateMetrics(FileTypeMetrics fileTypeMetrics, int len, long contentLength, long nextReadPos) {
        fileTypeMetrics.incrementReadCount();
        long readCount = fileTypeMetrics.getReadCount();
        if (readCount == 1L) {
            this.handleFirstRead(fileTypeMetrics, nextReadPos, len, contentLength);
        } else if (readCount == 2L) {
            this.handleSecondRead(fileTypeMetrics, nextReadPos, len, contentLength);
        } else {
            this.handleFurtherRead(fileTypeMetrics, len);
        }
    }

    private void handleFirstRead(FileTypeMetrics fileTypeMetrics, long nextReadPos, int len, long contentLength) {
        if (nextReadPos >= contentLength - (long)Integer.parseInt(FOOTER_LENGTH) * 1024L) {
            fileTypeMetrics.setCollectMetrics(true);
            fileTypeMetrics.setCollectMetricsForNextRead(true);
            fileTypeMetrics.setOffsetOfFirstRead(nextReadPos);
            fileTypeMetrics.setSizeReadByFirstRead(len + "_" + Math.abs(contentLength - nextReadPos));
        }
    }

    private void handleSecondRead(FileTypeMetrics fileTypeMetrics, long nextReadPos, int len, long contentLength) {
        if (fileTypeMetrics.getCollectMetricsForNextRead()) {
            long offsetDiff = Math.abs(nextReadPos - fileTypeMetrics.getOffsetOfFirstRead());
            fileTypeMetrics.setOffsetDiffBetweenFirstAndSecondRead(len + "_" + offsetDiff);
            fileTypeMetrics.setCollectLenMetrics(true);
            fileTypeMetrics.updateFileType();
            this.updateMetricsData(fileTypeMetrics, len, contentLength);
        }
    }

    private void handleFurtherRead(FileTypeMetrics fileTypeMetrics, int len) {
        if (fileTypeMetrics.getCollectLenMetrics() && fileTypeMetrics.getFileType() != null) {
            FileType fileType = fileTypeMetrics.getFileType();
            this.addMeanMetricValue(fileType, AbfsReadFooterMetricsEnum.AVG_READ_LEN_REQUESTED, len);
        }
    }

    private void updateMetricsData(FileTypeMetrics fileTypeMetrics, int len, long contentLength) {
        long sizeReadByFirstRead = Long.parseLong(fileTypeMetrics.getSizeReadByFirstRead().split("_")[0]);
        long firstOffsetDiff = Long.parseLong(fileTypeMetrics.getSizeReadByFirstRead().split("_")[1]);
        long secondOffsetDiff = Long.parseLong(fileTypeMetrics.getOffsetDiffBetweenFirstAndSecondRead().split("_")[1]);
        FileType fileType = fileTypeMetrics.getFileType();
        this.addMeanMetricValue(fileType, AbfsReadFooterMetricsEnum.AVG_READ_LEN_REQUESTED, len);
        this.addMeanMetricValue(fileType, AbfsReadFooterMetricsEnum.AVG_READ_LEN_REQUESTED, sizeReadByFirstRead);
        this.addMeanMetricValue(fileType, AbfsReadFooterMetricsEnum.AVG_FILE_LENGTH, contentLength);
        this.addMeanMetricValue(fileType, AbfsReadFooterMetricsEnum.AVG_SIZE_READ_BY_FIRST_READ, sizeReadByFirstRead);
        this.addMeanMetricValue(fileType, AbfsReadFooterMetricsEnum.AVG_OFFSET_DIFF_BETWEEN_FIRST_AND_SECOND_READ, len);
        this.addMeanMetricValue(fileType, AbfsReadFooterMetricsEnum.AVG_FIRST_OFFSET_DIFF, firstOffsetDiff);
        this.addMeanMetricValue(fileType, AbfsReadFooterMetricsEnum.AVG_SECOND_OFFSET_DIFF, secondOffsetDiff);
        this.incrementMetricValue(fileType, AbfsReadFooterMetricsEnum.TOTAL_FILES);
    }

    private void appendMetrics(StringBuilder metricBuilder, FileType fileType) {
        long totalFiles = this.getCounterMetricValue(fileType, AbfsReadFooterMetricsEnum.TOTAL_FILES);
        if (totalFiles <= 0L) {
            return;
        }
        String sizeReadByFirstRead = this.getMeanMetricValue(fileType, AbfsReadFooterMetricsEnum.AVG_SIZE_READ_BY_FIRST_READ);
        String offsetDiffBetweenFirstAndSecondRead = this.getMeanMetricValue(fileType, AbfsReadFooterMetricsEnum.AVG_OFFSET_DIFF_BETWEEN_FIRST_AND_SECOND_READ);
        if (FileType.NON_PARQUET.equals((Object)fileType)) {
            sizeReadByFirstRead = sizeReadByFirstRead + '_' + this.getMeanMetricValue(fileType, AbfsReadFooterMetricsEnum.AVG_FIRST_OFFSET_DIFF);
            offsetDiffBetweenFirstAndSecondRead = offsetDiffBetweenFirstAndSecondRead + '_' + this.getMeanMetricValue(fileType, AbfsReadFooterMetricsEnum.AVG_SECOND_OFFSET_DIFF);
        }
        metricBuilder.append("$").append((Object)fileType).append(":$FR=").append(sizeReadByFirstRead).append("$SR=").append(offsetDiffBetweenFirstAndSecondRead).append("$FL=").append(this.getMeanMetricValue(fileType, AbfsReadFooterMetricsEnum.AVG_FILE_LENGTH)).append("$RL=").append(this.getMeanMetricValue(fileType, AbfsReadFooterMetricsEnum.AVG_READ_LEN_REQUESTED));
    }

    @Override
    public String toString() {
        StringBuilder readFooterMetric = new StringBuilder();
        this.appendMetrics(readFooterMetric, FileType.PARQUET);
        this.appendMetrics(readFooterMetric, FileType.NON_PARQUET);
        return readFooterMetric.toString();
    }

    private static final class FileTypeMetrics {
        private final AtomicBoolean collectMetrics = new AtomicBoolean(false);
        private final AtomicBoolean collectMetricsForNextRead = new AtomicBoolean(false);
        private final AtomicBoolean collectLenMetrics = new AtomicBoolean(false);
        private final AtomicLong readCount = new AtomicLong(0L);
        private final AtomicLong offsetOfFirstRead = new AtomicLong(0L);
        private FileType fileType = null;
        private String sizeReadByFirstRead;
        private String offsetDiffBetweenFirstAndSecondRead;

        private FileTypeMetrics() {
        }

        private void updateFileType() {
            if (this.fileType == null) {
                this.fileType = this.collectMetrics.get() && this.readCount.get() >= 2L && this.haveEqualValues(this.sizeReadByFirstRead) && this.haveEqualValues(this.offsetDiffBetweenFirstAndSecondRead) ? FileType.PARQUET : FileType.NON_PARQUET;
            }
        }

        private boolean haveEqualValues(String value) {
            String[] parts = value.split("_");
            return parts.length == 2 && parts[0].equals(parts[1]);
        }

        private void incrementReadCount() {
            this.readCount.incrementAndGet();
        }

        private long getReadCount() {
            return this.readCount.get();
        }

        private void setCollectMetrics(boolean collect) {
            this.collectMetrics.set(collect);
        }

        private boolean getCollectMetrics() {
            return this.collectMetrics.get();
        }

        private void setCollectMetricsForNextRead(boolean collect) {
            this.collectMetricsForNextRead.set(collect);
        }

        private boolean getCollectMetricsForNextRead() {
            return this.collectMetricsForNextRead.get();
        }

        private boolean getCollectLenMetrics() {
            return this.collectLenMetrics.get();
        }

        private void setCollectLenMetrics(boolean collect) {
            this.collectLenMetrics.set(collect);
        }

        private void setOffsetOfFirstRead(long offset) {
            this.offsetOfFirstRead.set(offset);
        }

        private long getOffsetOfFirstRead() {
            return this.offsetOfFirstRead.get();
        }

        private void setSizeReadByFirstRead(String size) {
            this.sizeReadByFirstRead = size;
        }

        private String getSizeReadByFirstRead() {
            return this.sizeReadByFirstRead;
        }

        private void setOffsetDiffBetweenFirstAndSecondRead(String offsetDiff) {
            this.offsetDiffBetweenFirstAndSecondRead = offsetDiff;
        }

        private String getOffsetDiffBetweenFirstAndSecondRead() {
            return this.offsetDiffBetweenFirstAndSecondRead;
        }

        private FileType getFileType() {
            return this.fileType;
        }
    }
}

