/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.PathIOException;
import org.apache.hadoop.fs.StreamCapabilities;
import org.apache.hadoop.fs.Syncable;
import org.apache.hadoop.fs.azurebfs.constants.AbfsServiceType;
import org.apache.hadoop.fs.azurebfs.constants.FSOperationType;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AbfsRestOperationException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AzureBlobFileSystemException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.InvalidConfigurationValueException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.InvalidIngressServiceException;
import org.apache.hadoop.fs.azurebfs.contracts.services.AppendRequestParameters;
import org.apache.hadoop.fs.azurebfs.security.ContextEncryptionAdapter;
import org.apache.hadoop.fs.azurebfs.services.AbfsBlock;
import org.apache.hadoop.fs.azurebfs.services.AbfsClient;
import org.apache.hadoop.fs.azurebfs.services.AbfsClientHandler;
import org.apache.hadoop.fs.azurebfs.services.AbfsLease;
import org.apache.hadoop.fs.azurebfs.services.AbfsOutputStreamContext;
import org.apache.hadoop.fs.azurebfs.services.AbfsOutputStreamStatistics;
import org.apache.hadoop.fs.azurebfs.services.AbfsPerfInfo;
import org.apache.hadoop.fs.azurebfs.services.AbfsPerfTracker;
import org.apache.hadoop.fs.azurebfs.services.AbfsRestOperation;
import org.apache.hadoop.fs.azurebfs.services.AzureBlobIngressHandler;
import org.apache.hadoop.fs.azurebfs.services.AzureBlockManager;
import org.apache.hadoop.fs.azurebfs.services.AzureDFSIngressHandler;
import org.apache.hadoop.fs.azurebfs.services.AzureDfsToBlobIngressFallbackHandler;
import org.apache.hadoop.fs.azurebfs.services.AzureIngressHandler;
import org.apache.hadoop.fs.azurebfs.utils.CachedSASToken;
import org.apache.hadoop.fs.azurebfs.utils.Listener;
import org.apache.hadoop.fs.azurebfs.utils.TracingContext;
import org.apache.hadoop.fs.impl.BackReference;
import org.apache.hadoop.fs.impl.StoreImplementationUtils;
import org.apache.hadoop.fs.statistics.IOStatistics;
import org.apache.hadoop.fs.statistics.IOStatisticsSource;
import org.apache.hadoop.fs.store.DataBlocks;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.thirdparty.com.google.common.util.concurrent.ListeningExecutorService;
import org.apache.hadoop.thirdparty.com.google.common.util.concurrent.MoreExecutors;
import org.apache.hadoop.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbfsOutputStream
extends OutputStream
implements Syncable,
StreamCapabilities,
IOStatisticsSource {
    private volatile AbfsClient client;
    private final String path;
    private long position;
    private boolean closed;
    private boolean supportFlush;
    private boolean disableOutputStreamFlush;
    private boolean enableSmallWriteOptimization;
    private boolean isAppendBlob;
    private boolean isExpectHeaderEnabled;
    private volatile IOException lastError;
    private long lastFlushOffset;
    private long lastTotalAppendOffset = 0L;
    private final int bufferSize;
    private byte[] buffer;
    private int bufferIndex;
    private int numOfAppendsToServerSinceLastFlush;
    private final int maxConcurrentRequestCount;
    private final int maxRequestsThatCanBeQueued;
    private ConcurrentLinkedDeque<WriteOperation> writeOperations;
    private final ContextEncryptionAdapter contextEncryptionAdapter;
    private CachedSASToken cachedSasToken;
    private final String outputStreamId;
    private final TracingContext tracingContext;
    private Listener listener;
    private AbfsLease lease;
    private String leaseId;
    private final FileSystem.Statistics statistics;
    private final AbfsOutputStreamStatistics outputStreamStatistics;
    private IOStatistics ioStatistics;
    private static final Logger LOG = LoggerFactory.getLogger(AbfsOutputStream.class);
    private final DataBlocks.BlockFactory blockFactory;
    private long blockCount = 0L;
    private final ListeningExecutorService executorService;
    private final String eTag;
    private final BackReference fsBackRef;
    private final AbfsServiceType serviceTypeAtInit;
    private final boolean isDFSToBlobFallbackEnabled;
    private AbfsServiceType currentExecutingServiceType;
    private volatile AzureIngressHandler ingressHandler;
    private final AbfsClientHandler clientHandler;
    private final Lock lock = new ReentrantLock();
    private volatile boolean switchCompleted = false;

    public AbfsOutputStream(AbfsOutputStreamContext abfsOutputStreamContext) throws IOException {
        this.statistics = abfsOutputStreamContext.getStatistics();
        this.path = abfsOutputStreamContext.getPath();
        this.position = abfsOutputStreamContext.getPosition();
        this.closed = false;
        this.supportFlush = abfsOutputStreamContext.isEnableFlush();
        this.isExpectHeaderEnabled = abfsOutputStreamContext.isExpectHeaderEnabled();
        this.disableOutputStreamFlush = abfsOutputStreamContext.isDisableOutputStreamFlush();
        this.enableSmallWriteOptimization = abfsOutputStreamContext.isSmallWriteSupported();
        this.isAppendBlob = abfsOutputStreamContext.isAppendBlob();
        this.lastError = null;
        this.lastFlushOffset = 0L;
        this.bufferSize = abfsOutputStreamContext.getWriteBufferSize();
        this.bufferIndex = 0;
        this.numOfAppendsToServerSinceLastFlush = 0;
        this.writeOperations = new ConcurrentLinkedDeque();
        this.outputStreamStatistics = abfsOutputStreamContext.getStreamStatistics();
        this.fsBackRef = abfsOutputStreamContext.getFsBackRef();
        this.contextEncryptionAdapter = abfsOutputStreamContext.getEncryptionAdapter();
        this.eTag = abfsOutputStreamContext.getETag();
        this.maxConcurrentRequestCount = this.isAppendBlob ? 1 : abfsOutputStreamContext.getWriteMaxConcurrentRequestCount();
        this.maxRequestsThatCanBeQueued = abfsOutputStreamContext.getMaxWriteRequestsToQueue();
        this.lease = abfsOutputStreamContext.getLease();
        this.leaseId = abfsOutputStreamContext.getLeaseId();
        this.executorService = MoreExecutors.listeningDecorator(abfsOutputStreamContext.getExecutorService());
        this.cachedSasToken = new CachedSASToken(abfsOutputStreamContext.getSasTokenRenewPeriodForStreamsInSeconds());
        this.outputStreamId = this.createOutputStreamId();
        this.tracingContext = new TracingContext(abfsOutputStreamContext.getTracingContext());
        this.tracingContext.setStreamID(this.outputStreamId);
        this.tracingContext.setOperation(FSOperationType.WRITE);
        this.ioStatistics = this.outputStreamStatistics.getIOStatistics();
        this.blockFactory = abfsOutputStreamContext.getBlockFactory();
        this.isDFSToBlobFallbackEnabled = abfsOutputStreamContext.isDFSToBlobFallbackEnabled();
        this.serviceTypeAtInit = abfsOutputStreamContext.getIngressServiceType();
        this.currentExecutingServiceType = abfsOutputStreamContext.getIngressServiceType();
        this.clientHandler = abfsOutputStreamContext.getClientHandler();
        this.createIngressHandler(this.serviceTypeAtInit, abfsOutputStreamContext.getBlockFactory(), this.bufferSize, false, null);
    }

    public AzureIngressHandler getIngressHandler() {
        return this.ingressHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AzureIngressHandler createIngressHandler(AbfsServiceType serviceType, DataBlocks.BlockFactory blockFactory, int bufferSize, boolean isSwitch, AzureBlockManager blockManager) throws IOException {
        if (this.ingressHandler != null) {
            if (this.switchCompleted) {
                return this.ingressHandler;
            }
            this.lock.lock();
            try {
                if (this.switchCompleted) {
                    AzureIngressHandler azureIngressHandler = this.ingressHandler;
                    return azureIngressHandler;
                }
                AzureIngressHandler azureIngressHandler = this.createNewHandler(serviceType, blockFactory, bufferSize, isSwitch, blockManager);
                return azureIngressHandler;
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.createNewHandler(serviceType, blockFactory, bufferSize, isSwitch, blockManager);
    }

    private AzureIngressHandler createNewHandler(AbfsServiceType serviceType, DataBlocks.BlockFactory blockFactory, int bufferSize, boolean isSwitch, AzureBlockManager blockManager) throws IOException {
        this.client = this.clientHandler.getClient(serviceType);
        if (this.isDFSToBlobFallbackEnabled && this.serviceTypeAtInit != AbfsServiceType.DFS) {
            throw new InvalidConfigurationValueException("The ingress service type must be configured as DFS");
        }
        this.ingressHandler = this.isDFSToBlobFallbackEnabled && !isSwitch ? new AzureDfsToBlobIngressFallbackHandler(this, blockFactory, bufferSize, this.eTag, this.clientHandler) : (serviceType == AbfsServiceType.BLOB ? new AzureBlobIngressHandler(this, blockFactory, bufferSize, this.eTag, this.clientHandler, blockManager) : new AzureDFSIngressHandler(this, blockFactory, bufferSize, this.eTag, this.clientHandler));
        if (isSwitch) {
            this.switchCompleted = true;
        }
        return this.ingressHandler;
    }

    protected void switchHandler() throws IOException {
        if (this.serviceTypeAtInit != this.currentExecutingServiceType) {
            LOG.debug("Handler switch not required as serviceTypeAtInit {} is different from currentExecutingServiceType {}. This check prevents the handler from being switched more than once.", (Object)this.serviceTypeAtInit, (Object)this.currentExecutingServiceType);
            return;
        }
        this.currentExecutingServiceType = this.serviceTypeAtInit == AbfsServiceType.BLOB ? AbfsServiceType.DFS : AbfsServiceType.BLOB;
        LOG.info("Switching ingress handler to different service type: {}", (Object)this.currentExecutingServiceType);
        this.ingressHandler = this.createIngressHandler(this.currentExecutingServiceType, this.blockFactory, this.bufferSize, true, this.getBlockManager());
    }

    private int bufferData(AbfsBlock block, byte[] data, int off, int length) throws IOException {
        return this.getIngressHandler().bufferData(block, data, off, length);
    }

    private AbfsRestOperation remoteWrite(AbfsBlock blockToUpload, DataBlocks.BlockUploadData uploadData, AppendRequestParameters reqParams, TracingContext tracingContext) throws IOException {
        return this.getIngressHandler().remoteWrite(blockToUpload, uploadData, reqParams, tracingContext);
    }

    private AbfsRestOperation remoteFlush(long offset, boolean retainUncommitedData, boolean isClose, String leaseId, TracingContext tracingContext) throws IOException {
        return this.getIngressHandler().remoteFlush(offset, retainUncommitedData, isClose, leaseId, tracingContext);
    }

    private String createOutputStreamId() {
        return StringUtils.right(UUID.randomUUID().toString(), 12);
    }

    @Override
    public boolean hasCapability(String capability) {
        return this.supportFlush && StoreImplementationUtils.isProbeForSyncable(capability);
    }

    @Override
    public void write(int byteVal) throws IOException {
        this.write(new byte[]{(byte)(byteVal & 0xFF)});
    }

    @Override
    public synchronized void write(byte[] data, int off, int length) throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed!");
        }
        DataBlocks.validateWriteArgs(data, off, length);
        this.maybeThrowLastError();
        if (off < 0 || length < 0 || length > data.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (this.hasLease() && this.isLeaseFreed()) {
            throw new PathIOException(this.path, "Attempted to write to file without lease");
        }
        if (length == 0) {
            LOG.debug("No data to write, length is 0 for path: {}", (Object)this.path);
            return;
        }
        AbfsBlock block = this.createBlockIfNeeded(this.position);
        int written = this.bufferData(block, data, off, length);
        int remainingCapacity = block.remainingCapacity();
        if (written < length) {
            LOG.debug("writing more data than block capacity -triggering upload");
            this.uploadCurrentBlock();
            this.write(data, off + written, length - written);
        } else if (remainingCapacity == 0) {
            this.uploadCurrentBlock();
        }
        this.incrementWriteOps();
    }

    private synchronized AbfsBlock createBlockIfNeeded(long position) throws IOException {
        return this.getBlockManager().createBlock(position);
    }

    private synchronized void uploadCurrentBlock() throws IOException {
        Preconditions.checkState(this.getBlockManager().hasActiveBlock(), "No active block");
        LOG.debug("Writing block # {}", (Object)this.getBlockManager().getBlockCount());
        try {
            this.uploadBlockAsync(this.getBlockManager().getActiveBlock(), false, false);
        }
        finally {
            if (this.getBlockManager().hasActiveBlock()) {
                this.getBlockManager().clearActiveBlock();
            }
        }
    }

    private void uploadBlockAsync(AbfsBlock blockToUpload, boolean isFlush, boolean isClose) throws IOException {
        if (this.isAppendBlob) {
            this.getIngressHandler().writeAppendBlobCurrentBufferToService();
            return;
        }
        if (!blockToUpload.hasData()) {
            return;
        }
        ++this.numOfAppendsToServerSinceLastFlush;
        int bytesLength = blockToUpload.dataSize();
        long offset = this.position;
        this.position += (long)bytesLength;
        this.outputStreamStatistics.bytesToUpload(bytesLength);
        this.outputStreamStatistics.writeCurrentBuffer();
        DataBlocks.BlockUploadData blockUploadData = blockToUpload.startUpload();
        Future job = this.executorService.submit(() -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
        this.writeOperations.add(new WriteOperation(job, offset, bytesLength));
        this.shrinkWriteOperationQueue();
    }

    void failureWhileSubmit(Exception ex) throws IOException {
        if (ex instanceof AbfsRestOperationException && ((AbfsRestOperationException)ex).getStatusCode() == 404) {
            throw new FileNotFoundException(ex.getMessage());
        }
        this.lastError = ex instanceof IOException ? (IOException)ex : new IOException(ex);
        throw this.lastError;
    }

    boolean hasActiveBlockDataToUpload() {
        AzureBlockManager blockManager = this.getBlockManager();
        AbfsBlock activeBlock = blockManager.getActiveBlock();
        return blockManager.hasActiveBlock() && activeBlock.hasData();
    }

    private void incrementWriteOps() {
        if (this.statistics != null) {
            this.statistics.incrementWriteOps(1);
        }
    }

    private void maybeThrowLastError() throws IOException {
        if (this.lastError != null) {
            throw this.lastError;
        }
    }

    @Override
    public void flush() throws IOException {
        if (!this.disableOutputStreamFlush) {
            this.flushInternalAsync();
        }
    }

    @Override
    public void hsync() throws IOException {
        if (this.supportFlush) {
            this.flushInternal(false);
        }
    }

    @Override
    public void hflush() throws IOException {
        if (this.supportFlush) {
            this.flushInternal(false);
        }
    }

    public String getStreamID() {
        return this.outputStreamId;
    }

    public void registerListener(Listener listener1) {
        this.listener = listener1;
        this.tracingContext.setListener(this.listener);
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        try {
            if (this.hasActiveBlockDataToUpload() && this.executorService.isShutdown()) {
                throw new PathIOException(this.path, "Executor Service closed before writes could be completed.");
            }
            this.flushInternal(true);
        }
        catch (IOException e) {
            throw IOUtils.wrapException(this.path, e.getMessage(), e);
        }
        finally {
            if (this.contextEncryptionAdapter != null) {
                this.contextEncryptionAdapter.destroy();
            }
            if (this.hasLease()) {
                this.lease.free();
                this.lease = null;
            }
            this.lastError = new IOException("Stream is closed!");
            this.buffer = null;
            this.bufferIndex = 0;
            this.closed = true;
            this.writeOperations.clear();
            this.getBlockManager().close();
        }
        LOG.debug("Closing AbfsOutputStream : {}", (Object)this);
    }

    private synchronized void flushInternal(boolean isClose) throws IOException {
        this.maybeThrowLastError();
        if (!this.isAppendBlob && this.enableSmallWriteOptimization && this.numOfAppendsToServerSinceLastFlush == 0 && this.writeOperations.size() == 0 && this.hasActiveBlockDataToUpload()) {
            this.smallWriteOptimizedflushInternal(isClose);
            return;
        }
        if (this.hasActiveBlockDataToUpload()) {
            this.uploadCurrentBlock();
        }
        this.flushWrittenBytesToService(isClose);
        this.numOfAppendsToServerSinceLastFlush = 0;
    }

    private synchronized void smallWriteOptimizedflushInternal(boolean isClose) throws IOException {
        this.uploadBlockAsync(this.getBlockManager().getActiveBlock(), true, isClose);
        this.waitForAppendsToComplete();
        this.shrinkWriteOperationQueue();
        this.maybeThrowLastError();
        this.numOfAppendsToServerSinceLastFlush = 0;
    }

    private synchronized void flushInternalAsync() throws IOException {
        this.maybeThrowLastError();
        if (this.hasActiveBlockDataToUpload()) {
            this.uploadCurrentBlock();
        }
        this.waitForAppendsToComplete();
        this.flushWrittenBytesToServiceAsync();
    }

    private synchronized void waitForAppendsToComplete() throws IOException {
        for (WriteOperation writeOperation : this.writeOperations) {
            try {
                writeOperation.task.get();
            }
            catch (Exception ex2) {
                AzureBlobFileSystemException ex2;
                this.outputStreamStatistics.uploadFailed(writeOperation.length);
                if (ex2.getCause() instanceof AbfsRestOperationException && ((AbfsRestOperationException)ex2.getCause()).getStatusCode() == 404) {
                    throw new FileNotFoundException(ex2.getMessage());
                }
                if (ex2.getCause() instanceof AzureBlobFileSystemException) {
                    ex2 = (AzureBlobFileSystemException)ex2.getCause();
                }
                this.lastError = new IOException(ex2);
                throw this.lastError;
            }
        }
    }

    private synchronized void flushWrittenBytesToService(boolean isClose) throws IOException {
        this.waitForAppendsToComplete();
        this.flushWrittenBytesToServiceInternal(this.position, false, isClose);
    }

    private synchronized void flushWrittenBytesToServiceAsync() throws IOException {
        this.shrinkWriteOperationQueue();
        if (this.lastTotalAppendOffset > this.lastFlushOffset) {
            this.flushWrittenBytesToServiceInternal(this.lastTotalAppendOffset, true, false);
        }
    }

    private synchronized void flushWrittenBytesToServiceInternal(long offset, boolean retainUncommitedData, boolean isClose) throws IOException {
        if (this.isAppendBlob && !isClose) {
            return;
        }
        AbfsPerfTracker tracker = this.client.getAbfsPerfTracker();
        try (AbfsPerfInfo perfInfo = new AbfsPerfInfo(tracker, "flushWrittenBytesToServiceInternal", "flush");){
            AbfsRestOperation op;
            try {
                op = this.remoteFlush(offset, retainUncommitedData, isClose, this.leaseId, this.tracingContext);
            }
            catch (InvalidIngressServiceException ex) {
                LOG.debug("InvalidIngressServiceException caught for path: {}, switching handler and retrying remoteFlush.", (Object)this.getPath());
                this.switchHandler();
                op = this.remoteFlush(offset, retainUncommitedData, isClose, this.leaseId, this.tracingContext);
            }
            catch (AzureBlobFileSystemException ex) {
                if (ex instanceof AbfsRestOperationException && ((AbfsRestOperationException)ex).getStatusCode() == 404) {
                    throw new FileNotFoundException(ex.getMessage());
                }
                this.lastError = new IOException(ex);
                throw this.lastError;
            }
            if (op != null) {
                this.cachedSasToken.update(op.getSasToken());
                perfInfo.registerResult(op.getResult()).registerSuccess(true);
            }
            this.lastFlushOffset = offset;
        }
    }

    private synchronized void shrinkWriteOperationQueue() throws IOException {
        try {
            WriteOperation peek = this.writeOperations.peek();
            while (peek != null && peek.task.isDone()) {
                peek.task.get();
                this.lastTotalAppendOffset += peek.length;
                this.writeOperations.remove();
                peek = this.writeOperations.peek();
                this.outputStreamStatistics.queueShrunk();
            }
        }
        catch (Exception e) {
            this.lastError = e.getCause() instanceof AzureBlobFileSystemException ? (AzureBlobFileSystemException)e.getCause() : new IOException(e);
            throw this.lastError;
        }
    }

    @VisibleForTesting
    public synchronized void waitForPendingUploads() throws IOException {
        this.waitForAppendsToComplete();
    }

    @VisibleForTesting
    public AbfsOutputStreamStatistics getOutputStreamStatistics() {
        return this.outputStreamStatistics;
    }

    @VisibleForTesting
    public int getWriteOperationsSize() {
        return this.writeOperations.size();
    }

    @VisibleForTesting
    int getMaxConcurrentRequestCount() {
        return this.maxConcurrentRequestCount;
    }

    @VisibleForTesting
    int getMaxRequestsThatCanBeQueued() {
        return this.maxRequestsThatCanBeQueued;
    }

    @VisibleForTesting
    Boolean isAppendBlobStream() {
        return this.isAppendBlob;
    }

    @Override
    public IOStatistics getIOStatistics() {
        return this.ioStatistics;
    }

    @VisibleForTesting
    public boolean isLeaseFreed() {
        if (this.lease == null) {
            return true;
        }
        return this.lease.isFreed();
    }

    @VisibleForTesting
    public boolean hasLease() {
        return this.lease != null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("AbfsOutputStream@").append(this.hashCode());
        sb.append("){");
        sb.append(this.outputStreamStatistics.toString());
        sb.append("}");
        return sb.toString();
    }

    @VisibleForTesting
    BackReference getFsBackRef() {
        return this.fsBackRef;
    }

    @VisibleForTesting
    ListeningExecutorService getExecutorService() {
        return this.executorService;
    }

    @VisibleForTesting
    AbfsClient getClient() {
        return this.client;
    }

    public AbfsClientHandler getClientHandler() {
        return this.clientHandler;
    }

    public String getPath() {
        return this.path;
    }

    public synchronized long getPosition() {
        return this.position;
    }

    public synchronized void setPosition(long position) {
        this.position = position;
    }

    public String getCachedSasTokenString() {
        return this.cachedSasToken.get();
    }

    public ContextEncryptionAdapter getContextEncryptionAdapter() {
        return this.contextEncryptionAdapter;
    }

    public AzureBlockManager getBlockManager() {
        return this.getIngressHandler().getBlockManager();
    }

    public TracingContext getTracingContext() {
        return this.tracingContext;
    }

    public boolean isDFSToBlobFallbackEnabled() {
        return this.isDFSToBlobFallbackEnabled;
    }

    public boolean isExpectHeaderEnabled() {
        return this.isExpectHeaderEnabled;
    }

    public String getLeaseId() {
        return this.leaseId;
    }

    public CachedSASToken getCachedSasToken() {
        return this.cachedSasToken;
    }

    public boolean isAppendBlob() {
        return this.isAppendBlob;
    }

    @VisibleForTesting
    public Boolean areWriteOperationsTasksDone() {
        for (WriteOperation writeOperation : this.writeOperations) {
            if (writeOperation.task.isDone()) continue;
            return false;
        }
        return true;
    }

    private static class WriteOperation {
        private final Future<Void> task;
        private final long startOffset;
        private final long length;

        WriteOperation(Future<Void> task, long startOffset, long length) {
            Preconditions.checkNotNull(task, "task");
            Preconditions.checkArgument(startOffset >= 0L, "startOffset");
            Preconditions.checkArgument(length >= 0L, "length");
            this.task = task;
            this.startOffset = startOffset;
            this.length = length;
        }
    }
}

