/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.UUID;
import javax.net.ssl.SSLSession;
import org.apache.hadoop.fs.azurebfs.services.AbfsManagedHttpClientContext;
import org.apache.http.HttpConnectionMetrics;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.conn.ManagedHttpClientConnection;
import org.apache.http.conn.routing.HttpRoute;

class AbfsManagedApacheHttpConnection
implements ManagedHttpClientConnection {
    private final ManagedHttpClientConnection httpClientConnection;
    private AbfsManagedHttpClientContext managedHttpContext;
    private final HttpHost targetHost;
    private final int hashCode;

    AbfsManagedApacheHttpConnection(ManagedHttpClientConnection conn, HttpRoute route) {
        this.targetHost = route != null ? route.getTargetHost() : null;
        this.httpClientConnection = conn;
        this.hashCode = (UUID.randomUUID().toString() + this.httpClientConnection.getId()).hashCode();
    }

    void setManagedHttpContext(AbfsManagedHttpClientContext managedHttpContext) {
        this.managedHttpContext = managedHttpContext;
    }

    @Override
    public void close() throws IOException {
        this.httpClientConnection.close();
    }

    @Override
    public boolean isOpen() {
        return this.httpClientConnection.isOpen();
    }

    @Override
    public boolean isStale() {
        return this.httpClientConnection.isStale();
    }

    @Override
    public void setSocketTimeout(int timeout) {
        this.httpClientConnection.setSocketTimeout(timeout);
    }

    @Override
    public int getSocketTimeout() {
        return this.httpClientConnection.getSocketTimeout();
    }

    @Override
    public void shutdown() throws IOException {
        this.httpClientConnection.shutdown();
    }

    @Override
    public HttpConnectionMetrics getMetrics() {
        return this.httpClientConnection.getMetrics();
    }

    @Override
    public boolean isResponseAvailable(int timeout) throws IOException {
        long start = System.currentTimeMillis();
        boolean val = this.httpClientConnection.isResponseAvailable(timeout);
        this.managedHttpContext.addReadTime(System.currentTimeMillis() - start);
        return val;
    }

    @Override
    public void sendRequestHeader(HttpRequest request) throws HttpException, IOException {
        long start = System.currentTimeMillis();
        this.httpClientConnection.sendRequestHeader(request);
        this.managedHttpContext.addSendTime(System.currentTimeMillis() - start);
    }

    @Override
    public void sendRequestEntity(HttpEntityEnclosingRequest request) throws HttpException, IOException {
        long start = System.currentTimeMillis();
        this.httpClientConnection.sendRequestEntity(request);
        this.managedHttpContext.addSendTime(System.currentTimeMillis() - start);
    }

    @Override
    public HttpResponse receiveResponseHeader() throws HttpException, IOException {
        long start = System.currentTimeMillis();
        HttpResponse response = this.httpClientConnection.receiveResponseHeader();
        this.managedHttpContext.addReadTime(System.currentTimeMillis() - start);
        return response;
    }

    @Override
    public void receiveResponseEntity(HttpResponse response) throws HttpException, IOException {
        long start = System.currentTimeMillis();
        this.httpClientConnection.receiveResponseEntity(response);
        this.managedHttpContext.addReadTime(System.currentTimeMillis() - start);
    }

    @Override
    public void flush() throws IOException {
        long start = System.currentTimeMillis();
        this.httpClientConnection.flush();
        this.managedHttpContext.addSendTime(System.currentTimeMillis() - start);
    }

    @Override
    public String getId() {
        return this.httpClientConnection.getId();
    }

    @Override
    public void bind(Socket socket) throws IOException {
        this.httpClientConnection.bind(socket);
    }

    @Override
    public Socket getSocket() {
        return this.httpClientConnection.getSocket();
    }

    @Override
    public SSLSession getSSLSession() {
        return this.httpClientConnection.getSSLSession();
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.httpClientConnection.getLocalAddress();
    }

    @Override
    public int getLocalPort() {
        return this.httpClientConnection.getLocalPort();
    }

    @Override
    public InetAddress getRemoteAddress() {
        return this.httpClientConnection.getRemoteAddress();
    }

    @Override
    public int getRemotePort() {
        return this.httpClientConnection.getRemotePort();
    }

    public boolean equals(Object o) {
        if (o instanceof AbfsManagedApacheHttpConnection) {
            return this.httpClientConnection.getId().equals(((AbfsManagedApacheHttpConnection)o).httpClientConnection.getId());
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        StringBuilder stringBuilder = this.targetHost != null ? new StringBuilder(this.targetHost.toString()) : new StringBuilder();
        stringBuilder.append(":").append(this.hashCode());
        return stringBuilder.toString();
    }
}

