/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.fs.azurebfs.services.AbfsInputStreamStatistics;
import org.apache.hadoop.fs.statistics.IOStatistics;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsBinding;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsStore;

public class AbfsInputStreamStatisticsImpl
implements AbfsInputStreamStatistics {
    private final IOStatisticsStore ioStatisticsStore = IOStatisticsBinding.iostatisticsStore().withCounters("stream_read_seek_operations", "stream_read_seek_forward_operations", "stream_read_seek_backward_operations", "stream_read_bytes", "stream_read_seek_bytes_skipped", "stream_read_operations", "stream_read_bytes_backwards_on_seek", "seek_in_buffer", "bytes_read_buffer", "remote_read_op", "read_ahead_bytes_read", "remote_bytes_read").withDurationTracking("action_http_get_request").build();
    private final AtomicLong bytesRead = this.ioStatisticsStore.getCounterReference("stream_read_bytes");
    private final AtomicLong readOps = this.ioStatisticsStore.getCounterReference("stream_read_operations");
    private final AtomicLong seekOps = this.ioStatisticsStore.getCounterReference("stream_read_seek_operations");

    @Override
    public void seekBackwards(long negativeOffset) {
        this.seekOps.incrementAndGet();
        this.ioStatisticsStore.incrementCounter("stream_read_seek_backward_operations");
        this.ioStatisticsStore.incrementCounter("stream_read_bytes_backwards_on_seek", negativeOffset);
    }

    @Override
    public void seekForwards(long skipped) {
        this.seekOps.incrementAndGet();
        this.ioStatisticsStore.incrementCounter("stream_read_seek_forward_operations");
        this.ioStatisticsStore.incrementCounter("stream_read_seek_bytes_skipped", skipped);
    }

    @Override
    public void seek(long seekTo, long currentPos) {
        if (seekTo >= currentPos) {
            this.seekForwards(seekTo - currentPos);
        } else {
            this.seekBackwards(currentPos - seekTo);
        }
    }

    @Override
    public void bytesRead(long bytes) {
        this.bytesRead.addAndGet(bytes);
    }

    @Override
    public void bytesReadFromBuffer(long bytes) {
        this.ioStatisticsStore.incrementCounter("bytes_read_buffer", bytes);
    }

    @Override
    public void seekInBuffer() {
        this.ioStatisticsStore.incrementCounter("seek_in_buffer");
    }

    @Override
    public void readOperationStarted() {
        this.readOps.incrementAndGet();
    }

    @Override
    public void readAheadBytesRead(long bytes) {
        this.ioStatisticsStore.incrementCounter("read_ahead_bytes_read", bytes);
    }

    @Override
    public void remoteBytesRead(long bytes) {
        this.ioStatisticsStore.incrementCounter("remote_bytes_read", bytes);
    }

    @Override
    public void remoteReadOperation() {
        this.ioStatisticsStore.incrementCounter("remote_read_op");
    }

    @Override
    public IOStatistics getIOStatistics() {
        return this.ioStatisticsStore;
    }

    @VisibleForTesting
    public long getSeekOperations() {
        return this.ioStatisticsStore.counters().get("stream_read_seek_operations");
    }

    @VisibleForTesting
    public long getForwardSeekOperations() {
        return this.ioStatisticsStore.counters().get("stream_read_seek_forward_operations");
    }

    @VisibleForTesting
    public long getBackwardSeekOperations() {
        return this.ioStatisticsStore.counters().get("stream_read_seek_backward_operations");
    }

    @VisibleForTesting
    public long getBytesRead() {
        return this.ioStatisticsStore.counters().get("stream_read_bytes");
    }

    @VisibleForTesting
    public long getBytesSkippedOnSeek() {
        return this.ioStatisticsStore.counters().get("stream_read_seek_bytes_skipped");
    }

    @VisibleForTesting
    public long getBytesBackwardsOnSeek() {
        return this.ioStatisticsStore.counters().get("stream_read_bytes_backwards_on_seek");
    }

    @VisibleForTesting
    public long getSeekInBuffer() {
        return this.ioStatisticsStore.counters().get("seek_in_buffer");
    }

    @VisibleForTesting
    public long getReadOperations() {
        return this.ioStatisticsStore.counters().get("stream_read_operations");
    }

    @VisibleForTesting
    public long getBytesReadFromBuffer() {
        return this.ioStatisticsStore.counters().get("bytes_read_buffer");
    }

    @VisibleForTesting
    public long getRemoteReadOperations() {
        return this.ioStatisticsStore.counters().get("remote_read_op");
    }

    @VisibleForTesting
    public long getReadAheadBytesRead() {
        return this.ioStatisticsStore.counters().get("read_ahead_bytes_read");
    }

    @VisibleForTesting
    public long getRemoteBytesRead() {
        return this.ioStatisticsStore.counters().get("remote_bytes_read");
    }

    @VisibleForTesting
    public double getActionHttpGetRequest() {
        return this.ioStatisticsStore.meanStatistics().get("action_http_get_request.mean").mean();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("StreamStatistics{");
        sb.append(this.ioStatisticsStore.toString());
        sb.append('}');
        return sb.toString();
    }
}

