/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.fs.azurebfs.services.AbfsBlock;
import org.apache.hadoop.fs.azurebfs.services.AbfsOutputStream;

public class AbfsBlobBlock
extends AbfsBlock {
    private final String blockId;

    AbfsBlobBlock(AbfsOutputStream outputStream, long offset) throws IOException {
        super(outputStream, offset);
        this.blockId = this.generateBlockId(offset);
    }

    private String generateBlockId(long position) {
        String streamId = this.getOutputStream().getStreamID();
        String streamIdHash = Integer.toString(streamId.hashCode());
        String blockId = String.format("%d_%s", position, streamIdHash);
        byte[] blockIdByteArray = new byte[60];
        System.arraycopy(blockId.getBytes(StandardCharsets.UTF_8), 0, blockIdByteArray, 0, Math.min(60, blockId.length()));
        return new String(Base64.encodeBase64(blockIdByteArray), StandardCharsets.UTF_8);
    }

    @Override
    public String getBlockId() {
        return this.blockId;
    }
}

