/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.security;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.azurebfs.extensions.BoundDTExtension;
import org.apache.hadoop.fs.azurebfs.extensions.CustomDelegationTokenManager;
import org.apache.hadoop.fs.azurebfs.extensions.ExtensionHelper;
import org.apache.hadoop.fs.azurebfs.security.AbfsDelegationTokenIdentifier;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.delegation.web.DelegationTokenIdentifier;
import org.apache.hadoop.util.Preconditions;
import org.apache.hadoop.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbfsDelegationTokenManager
implements BoundDTExtension {
    private CustomDelegationTokenManager tokenManager;
    private static final Logger LOG = LoggerFactory.getLogger(AbfsDelegationTokenManager.class);

    public AbfsDelegationTokenManager(Configuration conf) throws IOException {
        Preconditions.checkNotNull(conf, "conf");
        Class<CustomDelegationTokenManager> customDelegationTokenMgrClass = conf.getClass("fs.azure.delegation.token.provider.type", null, CustomDelegationTokenManager.class);
        if (customDelegationTokenMgrClass == null) {
            throw new IllegalArgumentException("The value for \"fs.azure.delegation.token.provider.type\" is not defined.");
        }
        CustomDelegationTokenManager customTokenMgr = ReflectionUtils.newInstance(customDelegationTokenMgrClass, conf);
        Preconditions.checkArgument(customTokenMgr != null, "Failed to initialize %s.", customDelegationTokenMgrClass);
        customTokenMgr.initialize(conf);
        this.tokenManager = customTokenMgr;
    }

    @Override
    public void bind(URI fsURI, Configuration conf) throws IOException {
        Preconditions.checkNotNull(fsURI, "Np Filesystem URI");
        ExtensionHelper.bind(this.tokenManager, fsURI, conf);
    }

    @Override
    public String getCanonicalServiceName() {
        return ExtensionHelper.getCanonicalServiceName(this.tokenManager, null);
    }

    @Override
    public void close() {
        if (this.tokenManager instanceof Closeable) {
            IOUtils.cleanupWithLogger(LOG, (Closeable)((Object)this.tokenManager));
        }
    }

    public Token<DelegationTokenIdentifier> getDelegationToken(String renewer) throws IOException {
        LOG.debug("Requesting Delegation token for {}", (Object)renewer);
        Token<DelegationTokenIdentifier> token = this.tokenManager.getDelegationToken(renewer);
        if (token.getKind() == null) {
            token.setKind(AbfsDelegationTokenIdentifier.TOKEN_KIND);
        }
        return token;
    }

    public long renewDelegationToken(Token<?> token) throws IOException {
        return this.tokenManager.renewDelegationToken(token);
    }

    public void cancelDelegationToken(Token<?> token) throws IOException {
        this.tokenManager.cancelDelegationToken(token);
    }

    @VisibleForTesting
    public CustomDelegationTokenManager getTokenManager() {
        return this.tokenManager;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("AbfsDelegationTokenManager{");
        sb.append("tokenManager=").append(this.tokenManager);
        sb.append('}');
        return sb.toString();
    }
}

