/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.oauth2;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.fs.azurebfs.oauth2.AccessTokenProvider;
import org.apache.hadoop.fs.azurebfs.oauth2.AzureADAuthenticator;
import org.apache.hadoop.fs.azurebfs.oauth2.AzureADToken;
import org.apache.hadoop.thirdparty.com.google.common.base.Strings;
import org.apache.hadoop.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkloadIdentityTokenProvider
extends AccessTokenProvider {
    private static final String OAUTH2_TOKEN_PATH = "/oauth2/v2.0/token";
    private static final Logger LOG = LoggerFactory.getLogger(AccessTokenProvider.class);
    private static final String EMPTY_TOKEN_FILE_ERROR = "Empty token file found at specified path: ";
    private static final String TOKEN_FILE_READ_ERROR = "Error reading token file at specified path: ";
    private final String authEndpoint;
    private final String clientId;
    private final String tokenFile;
    private long tokenFetchTime = -1L;

    public WorkloadIdentityTokenProvider(String authority, String tenantId, String clientId, String tokenFile) {
        Preconditions.checkNotNull(authority, "authority");
        Preconditions.checkNotNull(tenantId, "tenantId");
        Preconditions.checkNotNull(clientId, "clientId");
        Preconditions.checkNotNull(tokenFile, "tokenFile");
        this.authEndpoint = authority + tenantId + OAUTH2_TOKEN_PATH;
        this.clientId = clientId;
        this.tokenFile = tokenFile;
    }

    @Override
    protected AzureADToken refreshToken() throws IOException {
        LOG.debug("AADToken: refreshing token from JWT Assertion");
        String clientAssertion = this.getClientAssertion();
        AzureADToken token = this.getTokenUsingJWTAssertion(clientAssertion);
        this.tokenFetchTime = System.currentTimeMillis();
        return token;
    }

    @Override
    protected boolean isTokenAboutToExpire() {
        boolean expiring;
        if (this.tokenFetchTime == -1L || super.isTokenAboutToExpire()) {
            return true;
        }
        long elapsedTimeSinceLastTokenRefreshInMillis = System.currentTimeMillis() - this.tokenFetchTime;
        boolean bl = expiring = elapsedTimeSinceLastTokenRefreshInMillis < 0L;
        if (expiring) {
            LOG.debug("JWTToken: token renewing. Time elapsed since last token fetch: {} milliseconds", (Object)elapsedTimeSinceLastTokenRefreshInMillis);
        }
        return expiring;
    }

    private String getClientAssertion() throws IOException {
        String clientAssertion = "";
        try {
            File file = new File(this.tokenFile);
            clientAssertion = FileUtils.readFileToString(file, "UTF-8");
        }
        catch (Exception e) {
            throw new IOException(TOKEN_FILE_READ_ERROR + this.tokenFile, e);
        }
        if (Strings.isNullOrEmpty(clientAssertion)) {
            throw new IOException(EMPTY_TOKEN_FILE_ERROR + this.tokenFile);
        }
        return clientAssertion;
    }

    @VisibleForTesting
    AzureADToken getTokenUsingJWTAssertion(String clientAssertion) throws IOException {
        return AzureADAuthenticator.getTokenUsingJWTAssertion(this.authEndpoint, this.clientId, clientAssertion);
    }

    @VisibleForTesting
    long getTokenFetchTime() {
        return this.tokenFetchTime;
    }
}

